;+
; PROJECT:
;   HESSI
; NAME:
;   HSI_ANNSEC_MPAT
;
; PURPOSE:
;   This routine builds modulation patterns on an annular sector grid.
;
; CATEGORY:
;   HESSI, UTIL, ANNSEC
;
; CALLING SEQUENCE:
;   mpat = hsi_annsec_mpat( i1, i2, cbe_obj, det_index, harmonic)
;
; CALLS:
;   HSI_ANNSEC_MAP
;
; INPUTS:
;       I1 - index of first modulation pattern.
;   I2 - index of last modulation pattern.
;   Cbe_obj - object containing hsi_calib_eventlist
;   det_index
;   harmonic

; OPTIONAL INPUTS:
;   none
;
; OUTPUTS:
;       none explicit, only through commons;
;
; OPTIONAL OUTPUTS:
;   none
;
; KEYWORDS:
;   MAP_PTR - pointer containing annular sector modulation patterns. If not passed,
;   this pointer must be available through cbe_obj.
; COMMON BLOCKS:
;   none
;
; SIDE EFFECTS:
;   none
;
; RESTRICTIONS:
;   none
;
; PROCEDURE:
;   none
;
; MODIFICATION HISTORY:
;   Version 1, richard.schwartz@gsfc.nasa.gov
;   Version 1.1, richard.schwartz 11-jun-2000.
;   Version 5, richard.schwartz@gsfc.nasa.gov 17-jul-2000.
;   - switching to interpolating on base maps. A modulation pattern is
;   composed of the weighted sum of four base maps. The phases are adjusted in the two sin/cos pairs to
;   match the phase of the real modulation pattern.  The weighting is assigned to the separate pairs based on
;   the distance of each (in rotation angle) from the rotation angle at the center of the event bin.
;   22-aug-2001, extract modulation pattern structure from cbe_obj, ras.
;	25-sep-2005, modified to work with stacked eventlists
;	18-may-2017, unused values removed
;-
function hsi_annsec_mpat,  i1, i2, mpat_obj, det_index, $
  rem_gridtran = rem_gridtran ;, harmonic


default, rem_gridtran, 0 ; if set, then vrate scaling set to 1
twopi = 2.0 * !pi
checkvar, harmonic, 0
if size(/tname,cbe_obj) eq 'POINTER' then cbe = cbe_obj else $
cbe = mpat_obj->getdata(class='hsi_calib_eventlist', this_det_index=det_index);,$
;    this_harmonic=harmonic)
if size(cbe,/tname) eq 'POINTER' THEN CBE = *CBE[DET_INDEX]
npat = i2-i1+1
;Stacks don't have .time field
;RAS, 18-may-2017, next values removed as not used
;time_unit = mpat_obj->get(/time_unit)
;livetime = chktag(cbe,'time') ? $
;    float(cbe.livetime * (cbe[1].time-cbe[0].time) / 2.0^20) * time_unit : $
;    cbe.livetime
;det_eff = (mpat_obj->get(/cbe_det_eff)).rel
;this_det_eff = det_eff[det_index]

;if not exist(mpat_obj) then mpat_obj = cbe_obj
mpat = mpat_obj->getdata(class='hsi_annsec_pattern', this_det_index=det_index) ;,$
;        this_harmonic=harmonic)

rmap_dim  = mpat.rmap_dim
phase_ptr = mpat.phase_ptr
total_phi = mpat.total_phi
harmonic  = mpat.harmonic

map_index = (*phase_ptr)[i1:i2].map_index


;cos_factor0 = float(cos((*phase_ptr)[i1:i2].dphase[0])* (*phase_ptr)[i1:i2].wcoef[0] * $
;   cbe[i1:i2].modamp*cbe[i1:i2].gridtran)
;sin_factor0 = float(sin((*phase_ptr)[i1:i2].dphase[0])* (*phase_ptr)[i1:i2].wcoef[0] *$
;   cbe[i1:i2].modamp*cbe[i1:i2].gridtran)*(*phase_ptr)[i1:i2].scoef[0]
;cos_factor1 = float(cos((*phase_ptr)[i1:i2].dphase[1])* (*phase_ptr)[i1:i2].wcoef[1] *$
;   cbe[i1:i2].modamp*cbe[i1:i2].gridtran)
;sin_factor1 = float(sin((*phase_ptr)[i1:i2].dphase[1])* (*phase_ptr)[i1:i2].wcoef[1] *$
;   cbe[i1:i2].modamp*cbe[i1:i2].gridtran)*(*phase_ptr)[i1:i2].scoef[1]

;vrate     = (cbe[i1:i2].modamp*cbe[i1:i2].gridtran)[*] ## (1.+fltarr(2))
out = fltarr(long(rmap_dim[0])*rmap_dim[1],npat)
gfctr = [1.,0.,0.]
for hh=0,harmonic-1 do begin
	cmp     = ptr_new(((*mpat.cmap_ptr)[*,*,hh])[*])
	smp     = ptr_new(((*mpat.smap_ptr)[*,*,hh])[*])
	gridtran = cbe[i1:i2].gridtran
	gridtran = ~rem_gridtran ? gridtran : gridtran * 0.0 + 1.0
	vrate = (cbe[i1:i2].modamp[hh] * gridtran ) ## (1.+fltarr(2))
	
	cos_factor  = reform((*phase_ptr)[i1:i2].phz_coef[*,0,hh])* vrate
	sin_factor  = reform((*phase_ptr)[i1:i2].phz_coef[*,1,hh])* vrate


	npixel = long(rmap_dim[0]*rmap_dim[1])-1


	for i=0L,i2-i1 do begin
	    index10  = map_index[0,i] * rmap_dim[0]

	    index20 = index10 + npixel
	    index11  = map_index[1,i] * rmap_dim[0]

	    index21 = index11 + npixel
      gridtran = rem_gridtran ? 0.0 : cbe[i+i1].gridtran*gfctr[hh]
	    out[0,i]  = out[*,i] + gridtran + $
	    (*cmp)[index10:index20] * cos_factor[0,i]  - $
	    (*smp)[index10:index20] * sin_factor[0,i]  + $
	    (*cmp)[index11:index21] * cos_factor[1,i]  - $
	    (*smp)[index11:index21] * sin_factor[1,i]
	    ;if (i mod 32) eq 0 then print, index10, index20,systime(1)-t1
	    endfor
	    ptr_free, cmp, smp

	endfor

return,  reform(out, rmap_dim[0], rmap_dim[1], npat,/over)
end
