;+
; :Description:
;    This procedure does the rate computation for the cartesian back-projection
;    Nothing fundamentally Cartesian but written for use with the 
;    Cartesian mod pattern structures
;
; :Params:
;    cc
;    cmpat
;    vrate
;    use_rate
;    tot_vrate
;
;
;
; :Author: richard
;-
pro hsi_cart_bproj_rates, cc, cmpat, vrate, use_rate, tot_vrate
  
  if use_rate then begin
    nbin = cmpat.nmap * cmpat.nphz

    tot_vrate = 0.0
    for im = 0, cmpat.nmaps-1 do begin
      ;message,'use_rate is set',/continue

      tot_vratei  = total(vrate[nbin[im]:nbin[im+1]-1])
      tot_vrate += tot_vratei
      vratei = f_div( vrate[nbin[im]:nbin[im+1]-1], cc[nbin[im]:nbin[im+1]-1].livetime) ; * (1.0 - cc[nbin[im]:nbin[im+1]-1].gap)

      norm = f_div( tot_vratei, total( vratei ))
      vrate[nbin[im]:nbin[im+1]-1] = vratei * norm
    endfor

  endif else begin
    vrate = vrate * (1.0 - cc.gap)
    tot_vrate  = total(vrate)
  endelse
end

