;+
; PROJECT:
; HESSI
; NAME:
; HSI_CART_MPATI_STK
;
; PURPOSE:
; This function returns cosine and sine moduluation patterns on a Cartesian grid
; as a function of rotation angle, grid orientation, and pixel specification.
; This only works for a stacked calibrated eventlist
;
; CATEGORY:
; HESSI, IMAGE
;
; CALLING SEQUENCE:
; cos_sin_i = $
;    HSI_CART_MPATI_STK(  cbeptr, det_index, nphz, image_dim,  pixel_size, pixel_coord) ;reuse pixel_coord
; CALLS:
; hsi_phase_pixel
;
; INPUTS: (all required)
;   cbeptr - calib_eventlist pointer array
;   det_index - 0-8, hessi grid index
;   nphz - number of phases per rotation angle 
;   image_dim - number of pixels in x and y, eg [64, 64]
;   pixel_size - pixel 2d size in arcseconds, often [1.0, 1.0]

;
;
; OUTPUTS:
;   pixel_coord  - computed and should appear as the final argument to be reused in subsequent calls (optional)
;   ;
;
; OPTIONAL OUTPUTS:
; none
;
; KEYWORDS:
;  
;
; COMMON BLOCKS:
; none
;
; SIDE EFFECTS:
; none
;
; RESTRICTIONS:
; none
;
; PROCEDURE:
; Builds cosine and sine modulation pattern maps for phase stacked calibrated eventlists for the rotation angle and
; phase of the first element in a stack group (same rot angle for 12 phases)
;
; MODIFICATION HISTORY:
; 20-aug-2015, richard.schwartz@nasa.gov

;-
function hsi_cart_mpati_stk,   cbeptr, det_index, nphz, image_dim, 	pixel_size, pixel_coord

default, pixel_size, fltarr(2)+1.0
if n_elements(pixel_size) eq 1 then pixel_size = pixel_size[0] + fltarr(2)
cbe = n_elements( cbeptr ) eq 1  ? *cbeptr[0] : *cbeptr[det_index]
npat = n_elements(cbe)/nphz/2 ;we only need phases covering 0-!pi, the rest we get from cos( A + !pi ) and sin( A +!pi )
pixel_coord = transpose(hsi_pixel_coord( image_dim ))
pixel =  pixel_coord ;pixel coords in asec  map_dim x 2
for i=0,1 do pixel[0,i] = pixel[*,i] * pixel_size[i]
ang_pitch = (hsi_grid_parameters()).pitch
orient    = (hsi_grid_parameters()).orient

;we only go halfway to !pi in delta roll_angle because we can get cos( phi + !pi ) at cos( phi ) and 
; sin( phi + !pi ) at -sin( phi ) !
out = hsi_phase_pixel( cbe[0:npat*nphz-1:nphz].roll_angle, !pi/2-orient[det_index], pixel, ang_pitch[det_index])

return,  [[cos(out)],[ sin(out)]]
end

