;---------------------------------------------------------------------------
; Document name: hsi_cart_pattern__define
; Created by:    Andre Csillaghy, May 1999
;
; Last Modified: Wed Jun 06 23:38:12 2001 (csillag@TOURNESOL)
;---------------------------------------------------------------------------
;
;+
; PROJECT:
;       HESSI
;
; NAME:
;       HESSI Cartesian MODULATION PATTERN CLASS DEFINITION
;
; PURPOSE:
;       Provides data structures and methods to work with modulation patterns
;
; CATEGORY:
;       HESSI Utilities
;
; CONSTRUCTION:
;       modul_pattern_obj = Obj_New( 'hsi_modul_pattern' ) ;
;
;       The variable modul_pattern_obj is the object references used to
;       access modulation pattern data and methods.
;
;
;
; SEE ALSO:
;      HESSI Objects Reference
;            http://hessi.ssl.berkeley.edu/software/reference.html
;
; HISTORY:
;		19-apr-2007, ras, harmonics integrated into modpats pointers
;		Aug 22, 2001, richard.schwartz
;			no longer uses hsi_annsec_map, now hsi_annsec_modul_pattern
;			and hsi_annsec_phase.
;       Release 6: inherits hsi_modul_pattern
;       Release 4: Really just a wrapper around HSI_Annsec_Map
;       Release 3 development, August / September 1999,
;           A Csillaghy, csillag@ssl.berkeley.edu
;       Based on the release 2 software of Richard Schwartz
;       Fundamental developments by Richard Schwartz, GSFC
;   	28-Feb-2011, kim, ras - in process, free existing cbe pointers.
;   	7-may-2017,
;-


FUNCTION HSI_Cart_Pattern::INIT, _EXTRA=_extra

  ret=self->Framework::INIT( CONTROL = hsi_cart_pattern_control(), $
    INFO={hsi_modul_pattern_info}, $
    _EXTRA= _extra )

  RETURN, 1

END
;----------------------------------------------------------

PRO HSI_Cart_Pattern::Set, $
  
  FOUND=found, NOT_FOUND=NOT_found, DONE=done, $
  _EXTRA= _extra

  
  IF Keyword_Set( _EXTRA ) THEN BEGIN
    self->HSI_Modul_Pattern_Strategy::Set, _EXTRA = _extra, FOUND=found, NOT_FOUND=NOT_found, DONE=done
  ENDIF

END



;----------------------------------------------------------

PRO Hsi_Cart_Pattern::Process, _EXTRA = _extra

  verbose = self->Get( /VERBOSE )
  IF 1 THEN Message, 'Processing Cartesian modulation patterns ', /INFO

  det_index = indgen(9) & n_det=9 ;21-sep-2010, ras Where( self->Get( /DET_INDEX_MASK ), n_det )
  ; Framework::setdata doesn't free any pointers that are inside self.data.
  ; Here, we will replace entire contents of self.data, so get current pointers and free them. kim, ras, 28-feb-2011
  map_arr = Self->framework::getdata(/noprocess)
  if ptr_chk(map_arr) then heap_free, map_arr ;map_arr holds many pointers
  ;;;;;;;;;
  map_arr = ptrarr(9,/alloc) 
  
  FOR i=0, n_det-1 DO BEGIN
    
    error = 0
    hsi_cart_modul_pattern, self,  cstrxi, this_map, $
      this_det_index = i, error=error
    
    if not error then *map_arr[i] = this_map	;kim 02-apr-2002
  ENDFOR
  hsi_cart_pattern_weight_map_build, self, map_arr
  self->SetData, map_arr
  
END

;----------------------------------------------------------

PRO Hsi_Cart_Pattern__Define

  dummy = {Hsi_Cart_Pattern, $
    INHERITS HSI_Modul_Pattern_Strategy }
END


;---------------------------------------------------------------------------
; End of 'hsi_annsec_pattern__define.pro'.
;---------------------------------------------------------------------------
