;+
; :Description:
;    Builds the average and average squared probability maps
;    used for the flatfield correction to back projection
;
; :Params:
;    obj - 
;    map_arr
;
;
;
; :Author: raschwar
;-
pro hsi_cart_pattern_weight_map_build, obj, map_arr, wmaps = wmaps
  
  hsi_square_mpat, obj, sqm, /rem_gridtran
  cbe = obj->getdata( class = 'hsi_calib_eventlist' )
  nmpat = ptr_count( cbe )
  cnmpat = long( total( /int, [0, nmpat], /cum) )
  ;Get the current weight map p and p^2
  valid = where( ptr_valid( cbe ), nvalid )
  
  image_dim = (*map_arr[ valid[0] ]).image_dim
  wmaps = fltarr( [ image_dim, 2, 9])
  for i = 0, nvalid -1 do begin
    j = valid[ i ]
    z = cnmpat[ j ] + lindgen( nmpat[j] )
    q = where( (*cbe[j]).livetime gt 0)
   
    s = reform( avg( sqm[ z[q], * ], 0), image_dim )
    s2 = reform( avg( sqm[ z[q], * ]^2, 0), image_dim )
    wmaps[ 0, 0, 0, j ] = [ [[s]], [[s2]]]
    
    (*map_arr[j]).weight_map_ptr = ptr_new( wmaps[ *, *, *, j ]  )
  endfor

end