;---------------------------------------------------------------------------
; Document name: hsi_clean_beam_polar.pro
; Created by:    sa"m from hsi_beam_clean.pro (richard's)
;
; Last Modified: 31 March 2007
;---------------------------------------------------------------------------
;+
; PROJECT:
;       HESSI
;
; NAME:
;       HSI_CLEAN_BEAM_polar()
;
; PURPOSE:
;
;
; CATEGORY:
;
;
; CALLING SEQUENCE:
;       result =help()
;
; INPUTS:
;
;
; OPTIONAL INPUTS:
;       None.
;
; OUTPUTS:
;       None.
;
; OPTIONAL OUTPUTS:
;       None.
;
; KEYWORDS:
;       None.
;
; COMMON BLOCKS:
;       None.
;
; PROCEDURE:
;
; RESTRICTIONS:
;       None.
;
; SIDE EFFECTS:
;       None.
;
; EXAMPLES:
;
;
; SEE ALSO:
;
; HISTORY:
;       Version
;       From Richard's
;	january 29, 2001: new clean beam, see email from gordon hurford (Thu, 25 Jan 2001 15:43:17 -0800)
; 29-Jan-2009: kim.  Added iter keyword. This will be used if the test_factor stuff is uncommented.
;   Brian and Sam had made these changes in an offline version:
;      march 29 2007: Sa"m Krucker added test_factor to control width of convolving Gaussian
;      march 31 2007: Brian Dennis added ability to use a different test_factor for each iteration.
;      I've commented out their changes and set test_factor to 1 so it has no effect by default.
;      To use a different test_factor, uncomment the code flagged below.
;	9-jul-2009, ras. Test factor has been changed to beam_width_factor and moved to hsi_sigma_clean_beam
;	     Previous comment about option to use different test_factor on each iteration is no longer true.
;	20-apr-2010, ras, handle normalization due to clean_beam_width_factor internally
;-

FUNCTION Hsi_Clean_Beam_Polar, XY, obj, clean_param ,norm=norm, iter=iter

  ;det_index_mask = obj->get(/det_index_mask)

  ;taperpsf = clean_param.taperpsf
  ;sigma_beam = clean_param.sigma_beam ;RAS, 29-oct-1999
  sigma_beam=hsi_sigma_clean_beam(obj, clean_param)
  is_cart = stregex( /bool, /fold, hsi_get_modpat_strategy( obj ), 'cart')

  ;det_index = where( det_index_mask, n_det)
  image_dim = is_cart ? obj->Get( /image_dim ) : obj->Get( /RMAP_DIM )
  image_dim=long(image_dim)

  Hsi_coord,obj, xmap, ymap, rmap, tmap
  gxy=findgen(2,image_dim[0]*image_dim[1])
  gxy[0,*]=xmap[*]
  gxy[1,*]=ymap[*]
  X = gxy[0, xy]
  Y=  gxy[1, xy]
  beam_width_factor = clean_param.beam_width_factor
  beam_width_factor = beam_width_factor eq 0 ? 1: beam_width_factor

  clean_beam =  (hsi_gauss2(gxy, [1.0,sigma_beam,sigma_beam, X, Y]))[*]
  clean_beam = clean_beam * beam_width_factor ^2 ;added 20-apr-2010, ras

  if keyword_set(norm) then begin
    ;integral over clean beam = 1   -----> units of convolved clean components are then photons (e.g. different from residual map)
    clean_beam=clean_beam/total(clean_beam)
  endif else begin
  endelse


  RETURN, clean_beam

END

;--------------------------------------------------------------------
