;+
; PROJECT:
;   HESSI
; NAME:
;   HSI_COORD
;
; PURPOSE:
;   This procedure computes the coordinates of the annular sector map in Cartesian
;   coordinates or returns the pixel coordinates for Cartesian modul pattern strategy.
; CATEGORY:
;   HESSI, IMAGE, UTIL, ANNSEC, CARTESIAN
;
; CALLING SEQUENCE:
;   Hsi_coord, hsi_img_obj, x, y
;
;
; INPUTS:
;   Hsi_img_obj - object containing calibrated eventlist object.  Should also contain modpat control object.
;   ;
;
; OPTIONAL KEYWORD INPUTS:
;
; OUTPUTS:
;   x - x coordinate in arcsec from Sun Center of annular sector map, dimensioned same as image.
;   y - y coordinate in arcsec from Sun Center of annular sector map, dimensioned same as image.
;   rmap - radial coordinate of annular sector map. Not necessarily from sun center, arcsec.
;   thetamap - azimuthal coordinate of annular sector map.  In radians.
;
; OPTIONAL OUTPUTS:
;   XY_STR - {  x:x, y:y }
;
; KEYWORDS:
;   none
; COMMON BLOCKS:
;   none
;
; SIDE EFFECTS:
;   none
;
; RESTRICTIONS:
;   none
;
; PROCEDURE:
;   Uses trigrid interpolation between the two systems for annsec.
;
; MODIFICATION HISTORY:
;   5-jun-2017, RAS, wraps hsi_annsec_coord and hsi_cart_coord
;  
;-
pro hsi_coord, hsi_img_obj, x, y, rmap, thetamap, XY_STR = xy_str, error= error, _extra = _extra
  strategy_name = hsi_get_modpat_strategy( hsi_img_obj )
  if stregex( /boo, strategy_name, /fold,'vismod') then begin
    message, /info, 'Strategy is ' + strategy_name
    message, 'Strategy must be HSI_ANNSEC_PATTERN or HSI_CART_PATTERN'
  endif
  error = 1
  is_cart = stregex( /boo, strategy_name, /fold,'cart')
  case 1 of
    is_cart: hsi_cart_coord, hsi_img_obj, x, y, _extra = _extra
    else: hsi_annsec_coord, hsi_img_obj, x, y, rmap, thetamap, _extra = _extra
  endcase
  if arg_present( xy_str ) then xy_str = { x:x, y:y }
  error = 0
  end
