;---------------------------------------------------------------------------
; Document name: hsi_modpat_products__define
; Created by:    Andre Csillaghy, May 1999
;
; Last Modified: Tue Sep 04 15:09:03 2001 (csillag@TOURNESOL)
;---------------------------------------------------------------------------
;
;+
; PROJECT:
;       HESSI
;
; NAME:
;       MODULATION PATTERN PRODUCTS CLASS DEFINITION
;
; PURPOSE: 
;       Provides a stadardized access interface to the  modulation
;       pattern data products, which are the modulation patterns, the
;       back projection, the modulation profiles and the point spread
;       function(s). 
;
;       This class is a container (strategy holder) of the four
;       objects hsi_modul_pattern, hsi_bproj, hsi_modul_profile, and
;       hsi_psf. HSI_Modul_Pattern is the source object of the other
;       three classes.  
;
; CATEGORY:
;       HESSI Utilities
; 
; CONSTRUCTION: 
;       modul_pattern_obj = Obj_New( 'hsi_modul_pattern' )
;
; INPUTS (CONTROL) PARAMETERS:
;
; OUTPUTS (INFO) PARAMETERS:
;
;
; SEE ALSO:
;      HESSI Utility Reference http://hessi.ssl.berkeley.edu/software/reference.html
;
; HISTORY:
;       Release 6: introduction of the strategy holder. ACs
;       Release 3 development, August / September 1999, 
;           A Csillaghy, csillag@ssl.berkeley.edu
;       Based on the release 2 software of Richard Schwartz
;       Fundamental developments by Richard Schwartz, GSFC
;-

;----------------------------------------------------------

FUNCTION Hsi_Modpat_Products::INIT, SOURCE = source, _EXTRA = _extra 

IF NOT Obj_Valid(source) THEN source = HSI_Modul_Pattern( _extra=_extra)

strategy_available = ['HSI_BPROJ', 'HSI_MODUL_PROFILE', 'HSI_PSF' ]
strategy_alternate_source = ['', '', 'HSI_BPROJ']

ret=self->Strategy_Holder::INIT( strategy_available, $
                                 strategy_alternate_source, $
                                 SOURCE=source )
; create this one too
self->SetStrategy, strategy_available[1]
self->SetStrategy, strategy_available[0]
self->Strategy_Holder::Set, MODPAT_PRODUCTS_AVAILABLE = strategy_available, /THIS_CLASS_ONLY

self.get_all_strategies =  1

RETURN, ret 

END

;----------------------------------------------------------

PRO Hsi_Modpat_Products__Define

modpat_products = {Hsi_Modpat_Products, $
                   INHERITS Strategy_Holder }

END


;---------------------------------------------------------------------------
; End of 'hsi_modpat_products__define.pro'.
;---------------------------------------------------------------------------
