;---------------------------------------------------------------------------
; Document name: hsi_modul_profile_cartesian__define
; Created by:    Andre Csillaghy, May 1999
;
; Last Modified: Fri Jul 20 13:14:25 2001 (csillag@sunlight)
;---------------------------------------------------------------------------
;
;+
; PROJECT:
;       HESSI
;
; NAME:
;       HESSI MODULATION PATTERN CLASS DEFINITION
;
; PURPOSE:
;       Provides data structures and methods to work with modulation patterns
;
; CATEGORY:
;       HESSI Utilities
;
; CONSTRUCTION:
;       modul_profile_cartesian_obj = Obj_New( 'hsi_modul_profile_cartesian' ) ;
;
;       The variable modul_profile_cartesian_obj is the object references used to
;       access modulation pattern data and methods.
;
; INHERITANCE
;       HSI_Calib_Eventlist (direct)
;       HSI_Eventlist, HSI_Packet, Universal
;
; INPUTS:
;       Provided by the "Set" method:
;       packet_obj->Set, KEYWORD=value
;       See below for the list of available keywords
;
; OUTPUTS:
;       For control variables: provided by the "Get" method;
;       For data: provided by the methods:
;                 GetModulPattern
;                 GetModulProfile
;                 GetBProj
;                 GetPSF
;
; OBJECT-SPECIFIC METHODS:
;

;
; SEE ALSO:
;      HESSI Utility Reference http://hessi.ssl.berkeley.edu/software/reference.html
;
; HISTORY:
;       Release 3 development, August / September 1999,
;           A Csillaghy, csillag@ssl.berkeley.edu
;       Based on the release 2 software of Richard Schwartz
;       Fundamental developments by Richard Schwartz, GSFC
;       Created from other modul_profile examples 25-may-2017, RAS
;-



;----------------------------------------------------------

FUNCTION Hsi_Modul_Profile_Cartesian::Modul_Profile_Hook, $
  VIMAGE=vimage, _EXTRA=_extra

  if keyword_set( _extra ) then Self->set, _extra = _extra
  ocmp = self->get(/source )  ;modul_pattern_object
  dcmp = ocmp->getdata()
  valid = where( ptr_valid( dcmp ), nvalid )
  out  = ptrarr( n_elements( dcmp ) )
  cbe  = self->getdata( class = 'hsi_calib_eventlist' )
  for i = 0, nvalid - 1 do $
    out[ valid[i] ] = $
      ptr_new( hsi_cart_profile( vimage, *cbe[ valid[i] ], *dcmp[ valid[i] ] ) )
  
  Return, out
END

;----------------------------------------------------------

PRO Hsi_Modul_Profile_cartesian__Define

modul_profile = {Hsi_Modul_Profile_cartesian, $
                 INHERITS HSI_Modul_Profile_Strategy}

END


;---------------------------------------------------------------------------
; End of 'hsi_modul_profile_cartesian__define.pro'.
;---------------------------------------------------------------------------
