;NAME:
;     hsi_pixon_smooth_patterns_diff
;PURPOSE:
;     Convolve universal modulation patterns with differenced pixon kernels or alternatively
;     take pixon convolved patterns and subtract them agains other pixon scale convolved patterns
;CATEGORY:
;     HESSI Pixon image reconstruction
;CALLING SEQUENCE:
;     hsi_pixon_smooth_patterns_diff, iobj, pixon_sizes, smoothed_patterns, $
;       diffresindex = diffresindex, diffresvalue = diffresvalue,
;INPUTS:
;     iobj = image object
;     pixon_sizes = list of pixon_sizes
;OPTIONAL INPUT PARAMETERS:
;KEYWORD PARAMETERS
;     writedir = directory to save smoothed patterns (only written if they
;                 need to bo computed) - not used, leftover
;     this_det = list of detectors to compute or read
;     this_harm = list of harmonics to compute of read
;     diffresindex = to use differential smoothing this is set to the
;                    index of the pixon scale to be differenced.  This is the
;                    index into *complete* pixon_sizes list as used in the
;                    hsi_pixon_local_smooth routine.
;     diffresvalue = pixon size which corresponds to diffresindex
;     /quiet = work quietly
;     tags - annsec or cart tags for the cos and sin modulation patterns
;     subtract_patterns = 1, 0 Compute difference patterns by subtracting existing instead of convolving
;       the difference of two pixons with the patterns, 1 (subtract) is the default and gives
;       better performance with identical results as convolution is a linear operator
;OUTPUTS:
;     smoothed_patterns = pointer array for smoothed patterns.  If this array
;                         has pointers to valid objects on input, they are
;                         freed before setting to new smoothed patterns
;COMMON BLOCKS:
;SIDE EFFECTS:
;RESTRICTIONS:
;PROCEDURE:
;MODIFICATION HISTORY:
;     T. Metcalf 2000-Oct-20
;     T. Metcalf 2001-Aug-29 Changed mpd logic.
;     T. Metcalf 2003-Mar-18 Changed logic so that if a smoothed mod
;                            patt is not read in successfully, then it
;                            is computed.  Previously, if there was an
;                            error in the smoothed patt file, this
;                            routine would stop with an error.
;     K. Tolbert 2010-Jan-04 Fixed bug where detector 9 alone didn't work.
;                            Also changed repeat loop to simpler test for valid ptrs.
;     Richard Schwartz, 2011-Mar-02 Set sfile = '' so won't use the smoothed modulation pattern
;                            files in SSWDB. They're the wrong dimension.
;     Richard Schwartz, 2015-Jan-16, break out the differencing of the smooth patterns from
;       hsi_pixon_smooth_patterns and introduce the subtraction of the convolved patterns instead of the
;       convolution using the differenced pixon kernels
;     Richard Schwartz, 2017-apr-05, use the standard format blocking and space around '=' ','
;     Richard Schwartz, 17-jun-2017, make it work with annsec or cart modpat tag names
;     
;-


pro hsi_pixon_smooth_patterns_diff, iobj, pixon_sizes, smoothed_patterns, $
  writedir = writedir, $
  this_det = this_det, this_harm = this_harm, $
  diffresindex = diffresindex, diffresvalue = diffresvalue, $
  ipixon = ipixon_index, $ ;Base pattern
  quiet = quiet, tags = tags, $
  subtract_patterns = subtract_patterns


  common hsi_pixon_bproj_private, units, smoothed_patterns_saved, save_pixon_sizes, npixons, savempd
  default, subtract_patterns, 1
  if subtract_patterns then begin
    ;if 0 then begin
    ;help, 'difference smoothing for, this_det, ipixon_index, diffresindex', this_det, ipixon_index, diffresindex
    sb = *smoothed_patterns_saved[ this_det, ipixon_index ]
    sd = *smoothed_patterns_saved[ this_det, diffresindex ]
    
    ix       = get_tag_index( sb, tags)
    sb_cmap     = *sb.(ix[0]) & sd_cmap = *sd.( ix[0] )
    sb_smap     = *sb.(ix[1]) & sd_smap = *sd.( ix[1] )
;    smoothed_patterns = ptr_new( {cmap_ptr:  ptr_new( *(sb.cmap_ptr) - *(sd.cmap_ptr)), $
;      smap_ptr:  ptr_new( *(sb.smap_ptr) - *(sd.smap_ptr)) } )
    smoothed_patterns = ptr_new( create_struct( tags[0], ptr_new( sb_cmap - sd_cmap ), $
      tags[1], ptr_new( sb_smap - sd_smap ) ) )
  endif else $
    hsi_pixon_smooth_patterns, iobj, pixon_sizes, smoothed_patterns, $
    writedir = writedir, $
    this_det = this_det, this_harm = this_harm, $
    tags = tags, $
    diffresindex = diffresindex, diffresvalue = diffresvalue, $
    quiet = quiet, low_memory = low_memory

end