;+
; PROJECT:
;   HESSI
; NAME:
;   HSI_PROFILE_ALL
;
; PURPOSE:
;   Returns time profile for an input image as expected counts
;   per time interval of associated calbrated eventlist.
;
; CATEGORY:
;   HESSI, UTIL
;
;
; CALLING SEQUENCE:
;
;   
;
;   Call it the following way when the modulation pattern maps are carried outside of the object.
;   This mode is used for testing.
;
;   map=hsi_profile_all( image, img_obj)

; CALLS:
;   none
;
; INPUTS:
;   Image  - Image to make profile from.  in annsec map coordinates
;   img_obj - hessi image object
;
;
; OPTIONAL INPUTS:
;
;
; OUTPUTS:
;       none explicit, only through commons;
;
; OPTIONAL OUTPUTS:
;   none
;
; KEYWORDS:
;	NONE
; COMMON BLOCKS:
;   none
;
; SIDE EFFECTS:
;   none
;
; RESTRICTIONS:
;   none
;
; PROCEDURE:
;   Calls hsi_annsec_profile supplying the modul patterns and calib_eventlists for all grids
;
; MODIFICATION HISTORY:
;	
; 18-jun-2017, ras, support for cartesian modul pattern added to annsec_profile_all
;-
function hsi_profile_all, image, img_obj
  ;
  ; This front section cycles through the  detectors

  is_annsec = stregex(/fold, /boolean, hsi_get_modpat_strategy( img_obj ), 'annsec')
  class = (['hsi_cart_pattern', 'hsi_annsec_pattern'])[ is_annsec ]
  
  omp =  img_obj->get(/obj, class = class)
  map_ptr = omp->framework::getdata()
  oc  =  img_obj->get(/obj, class='hsi_calib_eventlist')
  cbe =  oc->framework::getdata()
  det_eff =  (oc->get_det_eff()).rel
  n_det = 9
  out = ptrarr(n_det)
  default, time_unit, img_obj->get(/time_unit)
  time_bin = img_obj->Get(/time_bin_min, /time_bin_def)
  time_bin = long(time_bin.time_bin_min) * time_bin.time_bin_def

  time_bin = time_unit * time_bin

  if is_annsec then begin
  for det_index=0,n_det-1 do begin

    profile = hsi_annsec_profile( image, cbe, $
      time_bin = time_bin, $
      map_ptr=map_ptr, $
      this_det_index=det_index, $
      det_eff=det_eff);
    out[det_index]=ptr_new(profile)

  endfor
  endif else begin
  
    out = ptrarr(9)
    valid = where( ptr_valid( map_ptr ), nvalid )
    for i= 0, nvalid-1 do out[ valid[i] ] = ptr_new( hsi_cart_profile( image, map_ptr, *map_ptr[ valid[i] ] ))
  endelse
  return, out


end