/*
 * Decompiled with CFR 0.152.
 */
package org.egso.consumer;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import org.apache.commons.configuration.Configuration;
import org.apache.log4j.Logger;
import org.egso.common.Disposable;
import org.egso.common.configuration.NamedConfigurationFactory;
import org.egso.common.context.EGSOContextFactory;
import org.egso.common.externalinteraction.InteractionManager;
import org.egso.common.externalinteraction.InteractionManagerFactory;
import org.egso.common.logging.AbstractLogEnabled;
import org.egso.consumer.api.ConsumerException;
import org.egso.consumer.api.Data;
import org.egso.consumer.api.Query;
import org.egso.consumer.api.Type;
import org.egso.consumer.config.CatalogConfig;
import org.egso.consumer.config.CommonConfig;
import org.egso.consumer.config.DownloadConfig;
import org.egso.consumer.config.GoesXrayFlareConfig;
import org.egso.consumer.config.LinksConfig;
import org.egso.consumer.config.NoaaProtonEventConfig;
import org.egso.consumer.config.NoaaSrsArsConfig;
import org.egso.consumer.config.ObservationConfig;
import org.egso.consumer.config.PlotConfig;
import org.egso.consumer.config.VOTableIngestionConfig;
import org.egso.consumer.core.GenericData;
import org.egso.consumer.core.GenericType;
import org.egso.consumer.ssr.SSR;
import org.egso.consumer.types.egso.EGSOTypesFactory;

public class Consumer
extends AbstractLogEnabled {
    private boolean initialized = false;
    private boolean isDisposed = false;
    private static String consumerId = null;
    private static String hostAddress = null;
    private static String consumerVersion = null;
    private static EGSOContextFactory contextFactory = null;
    private static Consumer consumer = null;
    private static Configuration configuration = null;
    private static final String CACHE_NAME = "queryCache";
    private Cache queryCache = null;
    private static int qCounter;

    static {
        configuration = NamedConfigurationFactory.addNamedConfiguration((String)"org.egso.consumer", (String)"/org/egso/consumer/conf", (String)"consumer");
        qCounter = 0;
    }

    public Consumer() {
        try {
            CacheManager cacheManager = CacheManager.create();
            this.queryCache = cacheManager.getCache(CACHE_NAME);
        }
        catch (CacheException e) {
            throw new RuntimeException(e);
        }
    }

    public static Consumer getInstance() {
        if (consumer == null) {
            consumer = new Consumer();
            try {
                consumer.initialize();
            }
            catch (Exception e) {
                consumer.getLogger().error((Object)("Could not initialize Consumer. Hint: " + e.getMessage() + " (check logs for stacktrace)"), (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        return consumer;
    }

    public Logger getLogger(String name) {
        return Logger.getLogger((String)name);
    }

    private void initialize() {
        long startTime = System.currentTimeMillis();
        if (this.initialized) {
            throw new RuntimeException("Internal Error: The consumer has already been initialized");
        }
        if ("org.egso.consumer.eci.ECIConnector".equals(configuration.getString("consumer.eci.impl", "org.egso.consumer.eci.ECIConnector"))) {
            InteractionManager interactionManager = InteractionManagerFactory.getInteractionManager();
            consumerId = interactionManager.getId();
        } else {
            consumerId = "local";
        }
        ArrayList<CatalogConfig> configs = new ArrayList<CatalogConfig>();
        configs.add(new CommonConfig());
        configs.add(new SSR());
        configs.add(new GoesXrayFlareConfig());
        configs.add(new NoaaProtonEventConfig());
        configs.add(new NoaaSrsArsConfig());
        configs.add(new VOTableIngestionConfig());
        configs.add(new ObservationConfig());
        configs.add(new LinksConfig());
        configs.add(new PlotConfig());
        configs.add(new DownloadConfig());
        EGSOTypesFactory typesFactory = EGSOTypesFactory.getInstance();
        try {
            typesFactory.configure(configs);
        }
        catch (ConsumerException e) {
            throw new RuntimeException("Internal Error: Could not initialize EGSOTypesFactory. Cause: " + e.getMessage(), (Throwable)((Object)e));
        }
        Iterator iter = configs.iterator();
        while (iter.hasNext()) {
            CatalogConfig catalog = (CatalogConfig)iter.next();
            try {
                catalog.initParameters();
            }
            catch (ConsumerException e) {
                throw new RuntimeException("Internal Error: Could not initialize parameters for catalog '" + catalog.getName() + "' . Cause: " + e.getMessage(), (Throwable)((Object)e));
            }
        }
        if ("org.egso.consumer.eci.ECIConnector".equals(configuration.getString("consumer.eci.impl", "org.egso.consumer.eci.ECIConnector"))) {
            InteractionManager interactionManager = InteractionManagerFactory.getInteractionManager();
            consumerId = interactionManager.getId();
        } else {
            consumerId = "local";
        }
        consumerVersion = configuration.getString("consumer.version", "version unknown");
        try {
            hostAddress = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException ex) {
            hostAddress = "unknown";
        }
        contextFactory = EGSOContextFactory.newInstance((int)1, (String)consumerId, (String)consumerVersion, (String)hostAddress);
        if (this.getLogger().isInfoEnabled()) {
            this.getLogger().info((Object)("Consumer started up in " + (System.currentTimeMillis() - startTime) + " ms"));
        }
        this.initialized = true;
    }

    public void dispose() {
        if ("org.egso.consumer.eci.ECIConnector".equals(configuration.getString("consumer.eci.impl", "org.egso.consumer.eci.ECIConnector"))) {
            InteractionManager interactionManager = InteractionManagerFactory.getInteractionManager();
            if (interactionManager instanceof Disposable) {
                ((Disposable)interactionManager).dispose();
            }
        } else {
            consumerId = "local";
        }
        this.isDisposed = true;
    }

    public void finalize() {
        if (!this.isDisposed) {
            System.out.println("WARNING: Consumer.dispose() should be called by the client application, rather than in Consumer.finalize()");
            this.dispose();
        }
    }

    public static String getConsumerId() {
        return consumerId;
    }

    public static String getHostAddress() {
        return hostAddress;
    }

    public static String getVersion() {
        return consumerVersion;
    }

    public static EGSOContextFactory getContextFactory() {
        return contextFactory;
    }

    public static synchronized String genQpk() {
        return "Q" + ++qCounter;
    }

    public synchronized void putQuery(Query q) {
        this.queryCache.put(new Element((Serializable)((Object)q.id()), (Serializable)new SerializableQuery(q)));
    }

    public Query getQuery(String queryId) {
        try {
            Element el = this.queryCache.get((Serializable)((Object)queryId));
            if (el != null) {
                return ((SerializableQuery)el.getValue()).getQuery();
            }
            return null;
        }
        catch (CacheException e) {
            throw new RuntimeException(e);
        }
    }

    public String putData(String queryId, Data d) {
        try {
            Element el = this.queryCache.get((Serializable)((Object)queryId));
            if (el != null) {
                return ((SerializableQuery)el.getValue()).putData(d);
            }
            return null;
        }
        catch (CacheException e) {
            throw new RuntimeException(e);
        }
    }

    public Data getData(String queryId, String remoteDataId) {
        try {
            Element el = this.queryCache.get((Serializable)((Object)queryId));
            if (el != null) {
                return ((SerializableQuery)el.getValue()).resolveDataId(remoteDataId);
            }
            return null;
        }
        catch (CacheException e) {
            throw new RuntimeException(e);
        }
    }

    public String putType(String queryId, Type d) {
        try {
            Element el = this.queryCache.get((Serializable)((Object)queryId));
            if (el != null) {
                return ((SerializableQuery)el.getValue()).putType(d);
            }
            return null;
        }
        catch (CacheException e) {
            throw new RuntimeException(e);
        }
    }

    public Type getType(String queryId, String remoteTypeId) {
        try {
            Element el = this.queryCache.get((Serializable)((Object)queryId));
            if (el != null) {
                return ((SerializableQuery)el.getValue()).resolveTypeId(remoteTypeId);
            }
            return null;
        }
        catch (CacheException e) {
            throw new RuntimeException(e);
        }
    }

    public void disposeQuery(String queryId) {
        this.queryCache.remove((Serializable)((Object)queryId));
    }

    public void removeQuery(String id) {
        this.queryCache.remove((Serializable)((Object)id));
    }

    public static String getConsumerVersion() {
        return consumerVersion;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    final class SerializableQuery
    implements Serializable {
        private Map q2d = new HashMap();
        private final Query query;

        public SerializableQuery(Query query) {
            this.query = query;
        }

        public Query getQuery() {
            return this.query;
        }

        public String putData(Data d) {
            if (d == null) {
                return null;
            }
            if (!(d instanceof GenericData)) {
                throw new RuntimeException("only GenericData supported here but got " + (d == null ? "null" : d.getClass().getName()));
            }
            String remoteDataId = "QD" + ((GenericData)d).objectHashCode();
            this.q2d.put(remoteDataId, d);
            return remoteDataId;
        }

        public Data resolveDataId(String remoteDataId) {
            return (Data)this.q2d.get(remoteDataId);
        }

        public String putType(Type t) {
            if (t == null) {
                return null;
            }
            if (!(t instanceof GenericType)) {
                throw new RuntimeException("only GenericType supported here");
            }
            String remoteTypeId = "QT" + ((GenericType)t).objectHashCode();
            this.q2d.put(remoteTypeId, t);
            return remoteTypeId;
        }

        public Type resolveTypeId(String remoteTypeId) {
            return (Type)this.q2d.get(remoteTypeId);
        }

        private void readObject(ObjectInputStream in) {
            System.out.println(String.valueOf(this.getClass().getName()) + ".readObject(): this line should never appear");
        }

        private void writeObject(ObjectOutputStream out) {
            System.out.println(String.valueOf(this.getClass().getName()) + ".writeObject(): this line should never appear");
        }
    }
}

