/*
 * Decompiled with CFR 0.152.
 */
package org.egso.consumer.config;

import java.util.ArrayList;
import java.util.List;
import org.egso.consumer.api.ConsumerException;
import org.egso.consumer.config.CatalogConfig;
import org.egso.consumer.core.GenericData;
import org.egso.consumer.core.GenericType;
import org.egso.consumer.plot.LazyCosecImageData;
import org.egso.consumer.types.BooleanData;
import org.egso.consumer.types.DateData;
import org.egso.consumer.types.DoubleData;
import org.egso.consumer.types.EGSOContextData;
import org.egso.consumer.types.IntegerData;
import org.egso.consumer.types.ObjectData;
import org.egso.consumer.types.QuerySourceData;
import org.egso.consumer.types.StringData;

public class CommonConfig
extends CatalogConfig {
    public CommonConfig() {
        super(null);
    }

    public List getTypes() throws ConsumerException {
        ArrayList<GenericType> types = new ArrayList<GenericType>();
        GenericType dateType = DateData.getDateType();
        types.add(dateType);
        types.add(StringData.getStringType());
        DoubleData.DoubleType coord = new DoubleData.DoubleType("type_coord");
        types.add(coord);
        types.add(BooleanData.getBooleanType());
        GenericType pointing = new GenericType("type_pointing");
        pointing.setNeutralData(new GenericData(pointing){

            public void setValue(Object value) throws ConsumerException {
                if (value instanceof Object[] && ((Object[])value).length == 2) {
                    ((GenericData)this.get("longitude")).setValue(((Object[])value)[0]);
                    ((GenericData)this.get("latitude")).setValue(((Object[])value)[1]);
                } else {
                    super.setValue(value);
                }
            }
        });
        pointing.childrenTypes().put("longitude", coord);
        pointing.childrenTypes().put("latitude", coord);
        types.add(pointing);
        types.add(new IntegerData.IntegerType("type_unique_id"));
        types.add(LazyCosecImageData.getLazyCosecImageType());
        types.add(EGSOContextData.getEGSOContextType());
        types.add(QuerySourceData.getQuerySourceType());
        GenericType plotTypeSelectorType = new GenericType("type_plot_type_selector");
        GenericType plotTypeSelectorListType = new GenericType("_plottypelisttype");
        plotTypeSelectorListType.setElemsType(plotTypeSelectorType);
        GenericData plotTypeSelectorVD = (GenericData)plotTypeSelectorListType.newData();
        GenericData plotTypeXraySelector = (GenericData)plotTypeSelectorType.newData();
        plotTypeXraySelector.setId("goes-plot-xray");
        plotTypeSelectorVD.add(plotTypeXraySelector);
        GenericData plotTypeProtonSelector = (GenericData)plotTypeSelectorType.newData();
        plotTypeProtonSelector.setId("goes-plot-proton");
        plotTypeSelectorVD.add(plotTypeProtonSelector);
        plotTypeSelectorType.setValueDomain(plotTypeSelectorVD);
        types.add(plotTypeSelectorType);
        types.add(DoubleData.getDoubleType());
        types.add(IntegerData.getIntegerType());
        types.add(ObjectData.getObjectType());
        types.add(new GenericType("type_idarchive"));
        GenericType eventCatType = new GenericType("type_event_type");
        GenericType eventCatListType = new GenericType("_setof_eventtype");
        eventCatListType.setElemsType(eventCatType);
        eventCatType.setValueDomain((GenericData)eventCatListType.newData());
        types.add(eventCatType);
        return types;
    }

    public void initParameters() {
    }
}

