/*
 * Decompiled with CFR 0.152.
 */
package org.egso.consumer.config;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.egso.consumer.EGSOLiterals;
import org.egso.consumer.api.ConsumerException;
import org.egso.consumer.api.Data;
import org.egso.consumer.config.CatalogConfig;
import org.egso.consumer.core.AbstractParameter;
import org.egso.consumer.core.GenericQuery;
import org.egso.consumer.core.Result;
import org.egso.consumer.core.Updator;
import org.egso.consumer.types.FileHandleData;

public class DownloadConfig
extends CatalogConfig
implements Updator,
EGSOLiterals {
    public DownloadConfig() {
        super(null);
    }

    public List getTypes() throws ConsumerException {
        ArrayList<FileHandleData.FileHandleType> types = new ArrayList<FileHandleData.FileHandleType>();
        types.add(new FileHandleData.FileHandleType("type_ziparchive"));
        return types;
    }

    public void initParameters() throws ConsumerException {
        Result downloadResult = CatalogConfig.paramStore.resolveOrCreateResult("download", CatalogConfig.typesFactory.getType("type_ziparchive"));
        downloadResult.addDependsOn(CatalogConfig.paramStore.getParameter("link"));
        downloadResult.setUpdator(this);
    }

    public Data update(GenericQuery q, AbstractParameter param) throws ConsumerException {
        Data links = q.get("link");
        TreeSet<FileHandleData.FileWithNameMapping> linklist = new TreeSet<FileHandleData.FileWithNameMapping>();
        Iterator it = links.elements().iterator();
        while (it.hasNext()) {
            Data linkData = (Data)it.next();
            String url = linkData.get("link").id();
            if (url == null || "".equals(url)) continue;
            Data observatory = linkData.get("observatory");
            String observatoryName = observatory != null ? observatory.id() : "unknownobservatory";
            Data instrument = linkData.get("instrument");
            String instrumentName = instrument != null ? instrument.id() : "unknowninstrument";
            String path = null;
            try {
                path = String.valueOf(new URL(url).getHost()) + new URL(url).getPath();
            }
            catch (MalformedURLException ex) {
                path = url;
            }
            FileHandleData.FileWithNameMapping entry = new FileHandleData.FileWithNameMapping(url, String.valueOf(observatoryName) + "/" + instrumentName + "/" + path);
            linklist.add(entry);
        }
        return CatalogConfig.typesFactory.getType("type_ziparchive").newData(linklist);
    }
}

