/*
 * Decompiled with CFR 0.152.
 */
package org.egso.consumer.config;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import org.egso.consumer.EGSOLiterals;
import org.egso.consumer.api.ArgumentException;
import org.egso.consumer.api.ConsumerException;
import org.egso.consumer.api.Data;
import org.egso.consumer.api.Type;
import org.egso.consumer.config.CatalogConfig;
import org.egso.consumer.config.EventsConfig;
import org.egso.consumer.core.AbstractCatalogue;
import org.egso.consumer.core.AbstractParameter;
import org.egso.consumer.core.GenericData;
import org.egso.consumer.core.GenericQuery;
import org.egso.consumer.core.GenericType;
import org.egso.consumer.core.Parameter;
import org.egso.consumer.core.Result;
import org.egso.consumer.plot.LazyCosecImageData;
import org.egso.consumer.remotequery.FieldSelectorFactory;
import org.egso.consumer.remotequery.QuerySourceUpdator;
import org.egso.consumer.remotequery.RemoteUpdator;
import org.egso.consumer.types.IntegerData;
import org.egso.consumer.types.IntervalData;
import org.egso.consumer.types.XRayClassData;
import org.egso.consumer.types.votable.VOTableData;
import org.w3c.dom.Document;

public class GoesXrayFlareConfig
extends EventsConfig
implements EGSOLiterals {
    public GoesXrayFlareConfig() {
        super("goes_xray_flare");
    }

    public List getTypes() throws ConsumerException {
        ArrayList<GenericType> types = new ArrayList<GenericType>();
        IntegerData.IntegerType narValueType = new IntegerData.IntegerType("type_nar");
        types.add(narValueType);
        types.add(new IntervalData.IntervalType(narValueType));
        XRayClassData.XRayClassType xrayClassType = XRayClassData.getXRayClassType();
        types.add(xrayClassType);
        types.add(new IntervalData.IntervalType(xrayClassType));
        GenericType eventCatType = CatalogConfig.typesFactory.getType("type_event_type");
        Data eventCatFlare = eventCatType.newData();
        ((GenericData)eventCatFlare).setId("goes_xray_flare");
        eventCatType.valueDomain().add(eventCatFlare);
        GenericType flareType = new GenericType("type_goes_flare");
        flareType.childrenTypes().put("date", CatalogConfig.typesFactory.getType("type_date_interval"));
        flareType.childrenTypes().put("time_start", CatalogConfig.typesFactory.getType("type_date"));
        flareType.childrenTypes().put("time_peak", CatalogConfig.typesFactory.getType("type_date"));
        flareType.childrenTypes().put("time_end", CatalogConfig.typesFactory.getType("type_date"));
        flareType.childrenTypes().put("old_date", CatalogConfig.typesFactory.getType("type_date_interval"));
        flareType.childrenTypes().put("nar", narValueType);
        flareType.childrenTypes().put("xray_class", xrayClassType);
        flareType.childrenTypes().put("location", CatalogConfig.typesFactory.getType("type_pointing"));
        flareType.childrenTypes().put("longitude", CatalogConfig.typesFactory.getType("type_coord"));
        flareType.childrenTypes().put("latitude", CatalogConfig.typesFactory.getType("type_coord"));
        flareType.childrenTypes().put("IDArchive", CatalogConfig.typesFactory.getType("type_idarchive"));
        flareType.childrenTypes().put("goes-plot-xray", CatalogConfig.typesFactory.getType("type_plot_type"));
        flareType.childrenTypes().put("goes-plot-proton", CatalogConfig.typesFactory.getType("type_plot_type"));
        flareType.setNeutralData(new GenericData(flareType){

            public String id() {
                try {
                    Data uid = this.get("type_unique_id");
                    if (uid != null) {
                        return uid.id();
                    }
                }
                catch (ConsumerException consumerException) {
                    // empty catch block
                }
                return super.id();
            }
        });
        VOTableData.VOTableType flareListResultType = new VOTableData.VOTableType("type_goes_flare_list", new String[]{"date"});
        flareListResultType.setElemsType(flareType);
        flareListResultType.childrenTypes().put("goes-plot-proton", CatalogConfig.typesFactory.getType("type_plot_type"));
        flareListResultType.childrenTypes().put("goes-plot-xray", CatalogConfig.typesFactory.getType("type_plot_type"));
        flareListResultType.childrenTypes().put("context", CatalogConfig.typesFactory.getType("type_context"));
        flareListResultType.setEnum(true);
        GenericType flareListFsType = CatalogConfig.fsFactory.createFieldSelectorType("goes_xray_flare", "type_goes_flare_fs", new FieldSelectorFactory.FSEntry[]{new FieldSelectorFactory.FSEntry("time_start", 3), new FieldSelectorFactory.FSEntry("time_peak", 3), new FieldSelectorFactory.FSEntry("time_end", 3), new FieldSelectorFactory.FSEntry("nar", 1), new FieldSelectorFactory.FSEntry("xray_class", 1), new FieldSelectorFactory.FSEntry("longitude", 1), new FieldSelectorFactory.FSEntry("latitude", 1)});
        types.add(flareType);
        types.add(flareListResultType);
        types.add(flareListFsType);
        return types;
    }

    public void initParameters() throws ConsumerException {
        AbstractCatalogue eventCat = AbstractCatalogue.resolveOrCreateCatalogue("goes_xray_flare");
        ArrayList<Parameter> params = new ArrayList<Parameter>();
        params.add(CatalogConfig.paramStore.resolveOrCreateParameter("date", CatalogConfig.typesFactory.getType("type_date_interval"), eventCat));
        params.add(CatalogConfig.paramStore.resolveOrCreateParameter("time_start", CatalogConfig.typesFactory.getType("type_date"), eventCat));
        params.add(CatalogConfig.paramStore.resolveOrCreateParameter("time_end", CatalogConfig.typesFactory.getType("type_date"), eventCat));
        params.add(CatalogConfig.paramStore.resolveOrCreateParameter("time_peak", CatalogConfig.typesFactory.getType("type_date"), eventCat));
        params.add(CatalogConfig.paramStore.resolveOrCreateParameter("nar", CatalogConfig.typesFactory.getType("type_nar"), eventCat));
        params.add(CatalogConfig.paramStore.resolveOrCreateParameter("location", CatalogConfig.typesFactory.getType("type_pointing"), eventCat));
        params.add(CatalogConfig.paramStore.resolveOrCreateParameter("longitude", CatalogConfig.typesFactory.getType("type_coord"), eventCat));
        params.add(CatalogConfig.paramStore.resolveOrCreateParameter("latitude", CatalogConfig.typesFactory.getType("type_coord"), eventCat));
        params.add(CatalogConfig.paramStore.resolveOrCreateParameter("event_type", CatalogConfig.typesFactory.getType("type_event_type"), eventCat));
        params.add(CatalogConfig.paramStore.resolveOrCreateParameter("xray_class", CatalogConfig.typesFactory.getType("type_xray_class_interval"), eventCat));
        params.add(CatalogConfig.paramStore.resolveOrCreateParameter("unique_id", CatalogConfig.typesFactory.getType("type_unique_id"), eventCat));
        params.add(CatalogConfig.paramStore.resolveOrCreateParameter("goes_xray_flare_fs", (GenericData)CatalogConfig.typesFactory.getType("type_goes_flare_fs").newData(), eventCat));
        CatalogConfig.paramStore.resolveOrCreateParameter("goes_xray_flare", (GenericData)CatalogConfig.typesFactory.getType("type_goes_flare_list").newData(), eventCat);
        Result flareResultQs = CatalogConfig.paramStore.resolveOrCreateResult("goes_xray_flare_qs", CatalogConfig.typesFactory.getType("type_query_source"), eventCat);
        Result flareResult = CatalogConfig.paramStore.resolveOrCreateResult("goes_xray_flare", CatalogConfig.typesFactory.getType("type_goes_flare_list"), eventCat);
        Iterator iter = params.iterator();
        while (iter.hasNext()) {
            Parameter param = (Parameter)((Object)iter.next());
            flareResultQs.addDependsOn(param);
        }
        CatalogConfig.paramStore.resolveOrCreateParameter("event-plot-zoomout-lead", (GenericData)CatalogConfig.typesFactory.getType("type_double").newData("2"), eventCat);
        CatalogConfig.paramStore.resolveOrCreateParameter("event-plot-zoomout-trail", (GenericData)CatalogConfig.typesFactory.getType("type_double").newData("6"), eventCat);
        flareResultQs.setUpdator(new QuerySourceUpdator(){

            public Data update(GenericQuery q, AbstractParameter param) throws ConsumerException {
                Data eventType = q.get("event_type");
                if (q.isSet("event_type") && !eventType.id().equals("goes_xray_flare")) {
                    throw new ConsumerException("illegal event type '" + eventType.id() + "' for result '" + param.getDataKey() + "'");
                }
                if (eventType.id() == null) {
                    q.setValue("event_type", "goes_xray_flare");
                }
                Data superret = super.update(q, param);
                if (eventType.id() == null) {
                    q.unset("event_type");
                }
                return superret;
            }

            protected void xmlQuery(Document queryDoc, GenericQuery q, AbstractParameter param) throws ConsumerException {
                super.xmlQuery(queryDoc, q, param);
                queryDoc.getDocumentElement().getElementsByTagName("data").item(0).getAttributes().getNamedItem("type").setNodeValue("event");
            }
        });
        flareResult.addDependsOn(flareResultQs);
        flareResult.setUpdator(new RemoteUpdator("goes_xray_flare_qs"){

            protected void postprocessing(GenericQuery q, AbstractParameter param, Data vod) throws ArgumentException, ConsumerException {
                if (q.isSet("prefetch-plot-type")) {
                    String plotSelect = q.get("prefetch-plot-type").id();
                    vod.put(plotSelect, q.getResult(plotSelect));
                }
                Iterator it = vod.elements().iterator();
                while (it.hasNext()) {
                    Data flare = (Data)it.next();
                    Data date = flare.get("date");
                    if (date == null) continue;
                    Data startDate = date.get("time_start");
                    Data endDate = date.get("time_end");
                    if (startDate == null || endDate == null || startDate.getValue() == null || endDate.getValue() == null) continue;
                    long start = ((Calendar)startDate.getValue()).getTimeInMillis();
                    long end = ((Calendar)endDate.getValue()).getTimeInMillis();
                    long newstart = start;
                    long newend = end;
                    Data peakDate = flare.get("time_peak");
                    Data nData = q.get("event-plot-zoomout-lead");
                    Data mData = q.get("event-plot-zoomout-trail");
                    if (peakDate != null && nData != null && mData != null && q.isSet("time_peak") && q.isSet("event-plot-zoomout-lead") && q.isSet("event-plot-zoomout-trail")) {
                        long peak = ((Calendar)peakDate.getValue()).getTimeInMillis();
                        double n = (Double)nData.getValue();
                        double m = (Double)mData.getValue();
                        newstart = (long)((double)peak - n * (double)(peak - start));
                        newend = (long)((double)peak + m * (double)(end - peak));
                    } else if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug((Object)("could not zoom out for event '" + flare.id() + "' due to missing peak date or " + "relative offset information"));
                    }
                    Data oldStartDate = (Data)startDate.clone();
                    Data oldEndDate = (Data)endDate.clone();
                    Data oldDate = (Data)date.clone();
                    oldDate.put("time_start", oldStartDate);
                    oldDate.put("time_end", oldEndDate);
                    flare.put("old_date", oldDate);
                    startDate.setValue(new Long(newstart));
                    endDate.setValue(new Long(newend));
                    Data xrayPlot = ((Type)flare.childrenTypes().get("goes-plot-xray")).newData();
                    xrayPlot.setValue(new LazyCosecImageData.CosecCallArguments(startDate.id(), endDate.id(), 2));
                    flare.put("goes-plot-xray", xrayPlot);
                    Data protonPlot = ((Type)flare.childrenTypes().get("goes-plot-proton")).newData();
                    protonPlot.setValue(new LazyCosecImageData.CosecCallArguments(startDate.id(), endDate.id(), 1));
                    flare.put("goes-plot-proton", protonPlot);
                }
            }
        });
    }
}

