/*
 * Decompiled with CFR 0.152.
 */
package org.egso.consumer.config;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.egso.consumer.EGSOLiterals;
import org.egso.consumer.api.ConsumerException;
import org.egso.consumer.config.CatalogConfig;
import org.egso.consumer.core.AbstractCatalogue;
import org.egso.consumer.core.AbstractParameter;
import org.egso.consumer.core.GenericData;
import org.egso.consumer.core.GenericQuery;
import org.egso.consumer.core.GenericType;
import org.egso.consumer.core.Parameter;
import org.egso.consumer.core.Result;
import org.egso.consumer.remotequery.FieldSelectorFactory;
import org.egso.consumer.remotequery.QuerySourceUpdator;
import org.egso.consumer.remotequery.RemoteUpdator;
import org.egso.consumer.types.IntegerData;
import org.egso.consumer.types.votable.VOTableData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LinksConfig
extends CatalogConfig
implements EGSOLiterals {
    public LinksConfig() {
        super("link");
    }

    public List getTypes() throws ConsumerException {
        ArrayList<GenericType> types = new ArrayList<GenericType>();
        GenericType fileNameType = new GenericType("type_filename");
        GenericType hrefType = new GenericType("type_href");
        IntegerData.IntegerType fileSizeType = new IntegerData.IntegerType("type_filesize");
        GenericType linkType = new GenericType("type_link");
        linkType.childrenTypes().put("date", CatalogConfig.typesFactory.getType("type_date_interval"));
        linkType.childrenTypes().put("instrument", CatalogConfig.typesFactory.getType("type_instrument"));
        linkType.childrenTypes().put("observatory", CatalogConfig.typesFactory.getType("type_observatory"));
        linkType.childrenTypes().put("filename", fileNameType);
        linkType.childrenTypes().put("filesize", fileSizeType);
        linkType.childrenTypes().put("link", hrefType);
        linkType.childrenTypes().put("IDArchive", CatalogConfig.typesFactory.getType("type_idarchive"));
        VOTableData.VOTableType linkListResultType = new VOTableData.VOTableType("type_link_list", new String[]{"link"});
        linkListResultType.setElemsType(linkType);
        linkListResultType.setEnum(true);
        linkListResultType.childrenTypes().put("context", CatalogConfig.typesFactory.getType("type_context"));
        GenericType fsType = CatalogConfig.fsFactory.createFieldSelectorType("link", "type_link_fs", new FieldSelectorFactory.FSEntry[]{new FieldSelectorFactory.FSEntry("observatory", 1), new FieldSelectorFactory.FSEntry("instrument", 1), new FieldSelectorFactory.FSEntry("IDArchive", 1), new FieldSelectorFactory.FSEntry("time_start", 1), new FieldSelectorFactory.FSEntry("time_end", 1), new FieldSelectorFactory.FSEntry("filename", 1), new FieldSelectorFactory.FSEntry("link", 3)});
        types.add(linkType);
        types.add(fileNameType);
        types.add(hrefType);
        types.add(fileSizeType);
        types.add(linkListResultType);
        types.add(fsType);
        return types;
    }

    public void initParameters() throws ConsumerException {
        AbstractCatalogue linksCat = AbstractCatalogue.resolveOrCreateCatalogue("link");
        ArrayList<Parameter> params = new ArrayList<Parameter>();
        params.add(CatalogConfig.paramStore.resolveOrCreateParameter("date", (GenericData)CatalogConfig.typesFactory.getType("type_date_interval").newData(), linksCat));
        params.add(CatalogConfig.paramStore.resolveOrCreateParameter("link", (GenericData)CatalogConfig.typesFactory.getType("type_link_list").newData(), linksCat));
        params.add(CatalogConfig.paramStore.resolveOrCreateParameter("link_fs", (GenericData)CatalogConfig.typesFactory.getType("type_link_fs").newData(), linksCat));
        params.add(CatalogConfig.paramStore.getParameter("observation"));
        params.add(CatalogConfig.paramStore.getParameter("instrument"));
        Result linksResultQs = CatalogConfig.paramStore.resolveOrCreateResult("link_qs", CatalogConfig.typesFactory.getType("type_query_source"), linksCat);
        Result linksResult = CatalogConfig.paramStore.resolveOrCreateResult("link", CatalogConfig.typesFactory.getType("type_link_list"), linksCat);
        Iterator iter = params.iterator();
        while (iter.hasNext()) {
            AbstractParameter param = (AbstractParameter)((Object)iter.next());
            param.addCatalogue(linksCat);
            linksResultQs.addDependsOn(param);
        }
        linksResult.addDependsOn(linksResultQs);
        linksResultQs.setUpdator(new QuerySourceUpdator(){

            protected void xmlQuery(Document queryDoc, GenericQuery q, AbstractParameter param) throws ConsumerException {
                super.xmlQuery(queryDoc, q, param);
                Element data = (Element)queryDoc.getDocumentElement().getElementsByTagName("data").item(0);
                NodeList dataChildren = data.getChildNodes();
                ArrayList<Node> groupTags = new ArrayList<Node>();
                int i = 0;
                while (i < dataChildren.getLength()) {
                    Node current = dataChildren.item(i);
                    if (current instanceof Element && "group".equals(current.getNodeName())) {
                        groupTags.add(current);
                    }
                    ++i;
                }
                ArrayList<Node> paramTags = new ArrayList<Node>();
                int i2 = 0;
                while (i2 < dataChildren.getLength()) {
                    Node current = dataChildren.item(i2);
                    if (current instanceof Element && "param".equals(current.getNodeName())) {
                        if (groupTags.size() > 0 && "date".equals(((Element)current).getAttribute("name"))) {
                            data.removeChild(current);
                        } else {
                            paramTags.add(current);
                        }
                    }
                    ++i2;
                }
                if (groupTags.size() > 0 && paramTags.size() > 0) {
                    Element groupTag = queryDoc.createElement("group");
                    groupTag.setAttribute("relation", "OR");
                    Iterator iter = groupTags.iterator();
                    while (iter.hasNext()) {
                        Node current = (Node)iter.next();
                        data.removeChild(current);
                        groupTag.appendChild(current);
                    }
                    data.appendChild(groupTag);
                } else if (groupTags.size() > 0) {
                    data.setAttribute("relation", "OR");
                }
            }
        });
        linksResult.setUpdator(new RemoteUpdator("link_qs"));
    }
}

