/*
 * Decompiled with CFR 0.152.
 */
package org.egso.consumer.config;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import org.egso.consumer.EGSOLiterals;
import org.egso.consumer.api.ArgumentException;
import org.egso.consumer.api.ConsumerException;
import org.egso.consumer.api.Data;
import org.egso.consumer.api.Type;
import org.egso.consumer.config.CatalogConfig;
import org.egso.consumer.config.EventsConfig;
import org.egso.consumer.core.AbstractCatalogue;
import org.egso.consumer.core.AbstractParameter;
import org.egso.consumer.core.GenericData;
import org.egso.consumer.core.GenericQuery;
import org.egso.consumer.core.GenericType;
import org.egso.consumer.core.Parameter;
import org.egso.consumer.core.Result;
import org.egso.consumer.plot.LazyCosecImageData;
import org.egso.consumer.remotequery.FieldSelectorFactory;
import org.egso.consumer.remotequery.QuerySourceUpdator;
import org.egso.consumer.remotequery.RemoteUpdator;
import org.egso.consumer.types.IntegerData;
import org.egso.consumer.types.votable.VOTableData;
import org.w3c.dom.Document;

public class NoaaProtonEventConfig
extends EventsConfig
implements EGSOLiterals {
    public NoaaProtonEventConfig() {
        super("noaa_proton_event");
    }

    public List getTypes() throws ConsumerException {
        ArrayList<GenericType> types = new ArrayList<GenericType>();
        GenericType protonEventType = new GenericType("type_noaa_proton_event");
        protonEventType.childrenTypes().put("date", CatalogConfig.typesFactory.getType("type_date_interval"));
        protonEventType.childrenTypes().put("time_start", CatalogConfig.typesFactory.getType("type_date"));
        protonEventType.childrenTypes().put("time_peak", CatalogConfig.typesFactory.getType("type_date"));
        protonEventType.childrenTypes().put("time_end", CatalogConfig.typesFactory.getType("type_date"));
        protonEventType.childrenTypes().put("old_date", CatalogConfig.typesFactory.getType("type_date_interval"));
        protonEventType.childrenTypes().put("nar", CatalogConfig.typesFactory.getType("type_nar"));
        protonEventType.childrenTypes().put("location", CatalogConfig.typesFactory.getType("type_pointing"));
        protonEventType.childrenTypes().put("longitude", CatalogConfig.typesFactory.getType("type_coord"));
        protonEventType.childrenTypes().put("latitude", CatalogConfig.typesFactory.getType("type_coord"));
        protonEventType.childrenTypes().put("IDArchive", CatalogConfig.typesFactory.getType("type_idarchive"));
        protonEventType.childrenTypes().put("goes-plot-xray", CatalogConfig.typesFactory.getType("type_plot_type"));
        protonEventType.childrenTypes().put("goes-plot-proton", CatalogConfig.typesFactory.getType("type_plot_type"));
        VOTableData.VOTableType protonEventListResultType = new VOTableData.VOTableType("type_noaa_proton_event_list", new String[]{"date"});
        protonEventListResultType.setElemsType(protonEventType);
        protonEventListResultType.childrenTypes().put("goes-plot-proton", CatalogConfig.typesFactory.getType("type_plot_type"));
        protonEventListResultType.childrenTypes().put("goes-plot-xray", CatalogConfig.typesFactory.getType("type_plot_type"));
        protonEventListResultType.childrenTypes().put("context", CatalogConfig.typesFactory.getType("type_context"));
        protonEventListResultType.setEnum(true);
        GenericType protonEventListFsType = CatalogConfig.fsFactory.createFieldSelectorType("noaa_proton_event", "type_noaa_proton_event_fs", new FieldSelectorFactory.FSEntry[]{new FieldSelectorFactory.FSEntry("time_start", 3), new FieldSelectorFactory.FSEntry("time_peak", 3), new FieldSelectorFactory.FSEntry("nar", 1), new FieldSelectorFactory.FSEntry("latitude", 1), new FieldSelectorFactory.FSEntry("longitude", 1)});
        GenericType eventCatType = CatalogConfig.typesFactory.getType("type_event_type");
        Data eventCatFlare = eventCatType.newData();
        ((GenericData)eventCatFlare).setId("noaa_proton_event");
        eventCatType.valueDomain().add(eventCatFlare);
        types.add(protonEventType);
        types.add(protonEventListResultType);
        types.add(protonEventListFsType);
        return types;
    }

    public void initParameters() throws ConsumerException {
        AbstractCatalogue noaaProtonCat = AbstractCatalogue.resolveOrCreateCatalogue("noaa_proton_event");
        ArrayList<Parameter> params = new ArrayList<Parameter>();
        params.add(CatalogConfig.paramStore.getParameter("date"));
        params.add(CatalogConfig.paramStore.getParameter("time_start"));
        params.add(CatalogConfig.paramStore.getParameter("time_end"));
        params.add(CatalogConfig.paramStore.getParameter("nar"));
        params.add(CatalogConfig.paramStore.getParameter("location"));
        params.add(CatalogConfig.paramStore.getParameter("longitude"));
        params.add(CatalogConfig.paramStore.getParameter("latitude"));
        params.add(CatalogConfig.paramStore.resolveOrCreateParameter("prefetch-plot-type", CatalogConfig.typesFactory.getType("type_plot_type"), noaaProtonCat));
        params.add(CatalogConfig.paramStore.getParameter("event_type"));
        params.add(CatalogConfig.paramStore.resolveOrCreateParameter("noaa_proton_event_fs", (GenericData)CatalogConfig.typesFactory.getType("type_noaa_proton_event_fs").newData(), noaaProtonCat));
        CatalogConfig.paramStore.resolveOrCreateParameter("noaa_proton_event", (GenericData)CatalogConfig.typesFactory.getType("type_noaa_proton_event_list").newData(), noaaProtonCat);
        Result protonResultQs = CatalogConfig.paramStore.resolveOrCreateResult("noaa_proton_event_qs", CatalogConfig.typesFactory.getType("type_query_source"), noaaProtonCat);
        Result protonResult = CatalogConfig.paramStore.resolveOrCreateResult("noaa_proton_event", CatalogConfig.typesFactory.getType("type_noaa_proton_event_list"), noaaProtonCat);
        Iterator iter = params.iterator();
        while (iter.hasNext()) {
            Parameter param = (Parameter)((Object)iter.next());
            protonResultQs.addDependsOn(param);
        }
        CatalogConfig.paramStore.resolveOrCreateParameter("noaa_proton_time_dec", (GenericData)CatalogConfig.typesFactory.getType("type_integer").newData("0"), noaaProtonCat);
        CatalogConfig.paramStore.resolveOrCreateParameter("noaa_proton_time_inc", (GenericData)CatalogConfig.typesFactory.getType("type_integer").newData("86400000"), noaaProtonCat);
        protonResultQs.setUpdator(new QuerySourceUpdator(){

            public Data update(GenericQuery q, AbstractParameter param) throws ConsumerException {
                Data eventType = q.get("event_type");
                if (q.isSet("event_type") && !eventType.id().equals("noaa_proton_event")) {
                    throw new ConsumerException("illegal event type '" + eventType.id() + "' for result '" + param.getDataKey() + "'");
                }
                if (eventType.id() == null) {
                    q.setValue("event_type", "noaa_proton_event");
                }
                Data superret = super.update(q, param);
                if (eventType.id() == null) {
                    q.unset("event_type");
                }
                return superret;
            }

            protected void xmlQuery(Document queryDoc, GenericQuery q, AbstractParameter param) throws ConsumerException {
                super.xmlQuery(queryDoc, q, param);
                queryDoc.getDocumentElement().getElementsByTagName("data").item(0).getAttributes().getNamedItem("type").setNodeValue("event");
            }
        });
        protonResult.addDependsOn(protonResultQs);
        protonResult.setUpdator(new RemoteUpdator("noaa_proton_event_qs"){

            protected void postprocessing(GenericQuery q, AbstractParameter param, Data vod) throws ArgumentException, ConsumerException {
                if (q.isSet("prefetch-plot-type")) {
                    String plotSelect = q.get("prefetch-plot-type").id();
                    vod.put(plotSelect, q.getResult(plotSelect));
                }
                Iterator it = vod.elements().iterator();
                while (it.hasNext()) {
                    long start;
                    Data startDate;
                    Data flare = (Data)it.next();
                    Data date = flare.get("date");
                    if (date == null || (startDate = date.get("time_start")) == null || startDate.getValue() == null) continue;
                    long newstart = start = ((Calendar)startDate.getValue()).getTimeInMillis();
                    long newend = 0L;
                    Data incData = q.get("noaa_proton_time_inc");
                    Data decData = q.get("noaa_proton_time_dec");
                    if (incData != null && decData != null && q.isSet("noaa_proton_time_inc") && q.isSet("noaa_proton_time_dec")) {
                        long inc = ((IntegerData)incData).getVal();
                        long dec = ((IntegerData)decData).getVal();
                        newstart = start - dec;
                        newend = start + inc;
                    } else if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug((Object)("could not zoom out for event '" + flare.id() + "' due to missing peak date or " + "relative offset information"));
                    }
                    Data oldStartDate = (Data)startDate.clone();
                    Data oldDate = (Data)date.clone();
                    oldDate.put("time_start", oldStartDate);
                    flare.put("old_date", oldDate);
                    startDate.setValue(new Long(newstart));
                    q.setValue("time_end", new Long(newend));
                    Data endDate = q.get("time_end");
                    Data xrayPlot = ((Type)flare.childrenTypes().get("goes-plot-xray")).newData();
                    xrayPlot.setValue(new LazyCosecImageData.CosecCallArguments(startDate.id(), endDate.id(), 2));
                    flare.put("goes-plot-xray", xrayPlot);
                    Data protonPlot = ((Type)flare.childrenTypes().get("goes-plot-proton")).newData();
                    protonPlot.setValue(new LazyCosecImageData.CosecCallArguments(startDate.id(), endDate.id(), 1));
                    flare.put("goes-plot-proton", protonPlot);
                }
            }
        });
    }
}

