/*
 * Decompiled with CFR 0.152.
 */
package org.egso.consumer.config;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import org.egso.consumer.EGSOLiterals;
import org.egso.consumer.api.ArgumentException;
import org.egso.consumer.api.ConsumerException;
import org.egso.consumer.api.Data;
import org.egso.consumer.api.Type;
import org.egso.consumer.config.CatalogConfig;
import org.egso.consumer.config.EventsConfig;
import org.egso.consumer.core.AbstractCatalogue;
import org.egso.consumer.core.AbstractParameter;
import org.egso.consumer.core.GenericData;
import org.egso.consumer.core.GenericQuery;
import org.egso.consumer.core.GenericType;
import org.egso.consumer.core.Parameter;
import org.egso.consumer.core.Result;
import org.egso.consumer.plot.LazyCosecImageData;
import org.egso.consumer.remotequery.FieldSelectorFactory;
import org.egso.consumer.remotequery.QuerySourceUpdator;
import org.egso.consumer.remotequery.RemoteUpdator;
import org.egso.consumer.types.votable.VOTableData;
import org.w3c.dom.Document;

public class NoaaSrsArsConfig
extends EventsConfig
implements EGSOLiterals {
    public NoaaSrsArsConfig() {
        super("srs_list");
    }

    public List getTypes() throws ConsumerException {
        ArrayList<GenericType> types = new ArrayList<GenericType>();
        GenericType srsType = new GenericType("type_noaa_srs_feature");
        srsType.childrenTypes().put("date", CatalogConfig.typesFactory.getType("type_date_interval"));
        srsType.childrenTypes().put("time_start", CatalogConfig.typesFactory.getType("type_date"));
        srsType.childrenTypes().put("nar", CatalogConfig.typesFactory.getType("type_nar"));
        srsType.childrenTypes().put("location", CatalogConfig.typesFactory.getType("type_pointing"));
        srsType.childrenTypes().put("longitude", CatalogConfig.typesFactory.getType("type_coord"));
        srsType.childrenTypes().put("latitude", CatalogConfig.typesFactory.getType("type_coord"));
        srsType.childrenTypes().put("IDArchive", CatalogConfig.typesFactory.getType("type_idarchive"));
        srsType.childrenTypes().put("goes-plot-xray", CatalogConfig.typesFactory.getType("type_plot_type"));
        srsType.childrenTypes().put("goes-plot-proton", CatalogConfig.typesFactory.getType("type_plot_type"));
        srsType.setNeutralData(new GenericData(srsType){

            public String id() {
                try {
                    Data uid = this.get("unique_id");
                    if (uid != null) {
                        return uid.id();
                    }
                }
                catch (ConsumerException consumerException) {
                    // empty catch block
                }
                return super.id();
            }
        });
        VOTableData.VOTableType srsListResultType = new VOTableData.VOTableType("type_noaa_srs_feature_list", new String[]{"date"});
        srsListResultType.setElemsType(srsType);
        srsListResultType.childrenTypes().put("goes-plot-proton", CatalogConfig.typesFactory.getType("type_plot_type"));
        srsListResultType.childrenTypes().put("goes-plot-xray", CatalogConfig.typesFactory.getType("type_plot_type"));
        srsListResultType.childrenTypes().put("context", CatalogConfig.typesFactory.getType("type_context"));
        srsListResultType.setEnum(true);
        GenericType srsFsType = CatalogConfig.fsFactory.createFieldSelectorType("srs_list", "type_noaa_srs_feature_fs", new FieldSelectorFactory.FSEntry[]{new FieldSelectorFactory.FSEntry("time_start", 3), new FieldSelectorFactory.FSEntry("nar", 1), new FieldSelectorFactory.FSEntry("latitude", 3), new FieldSelectorFactory.FSEntry("longitude", 3)});
        GenericType eventCatType = CatalogConfig.typesFactory.getType("type_event_type");
        Data eventCatFlare = eventCatType.newData();
        ((GenericData)eventCatFlare).setId("srs_list");
        eventCatType.valueDomain().add(eventCatFlare);
        types.add(srsType);
        types.add(srsListResultType);
        types.add(srsFsType);
        return types;
    }

    public void initParameters() throws ConsumerException {
        AbstractCatalogue noaaSRSCat = AbstractCatalogue.resolveOrCreateCatalogue("srs_list");
        ArrayList<Parameter> params = new ArrayList<Parameter>();
        params.add(CatalogConfig.paramStore.getParameter("date"));
        params.add(CatalogConfig.paramStore.getParameter("time_start"));
        params.add(CatalogConfig.paramStore.getParameter("nar"));
        params.add(CatalogConfig.paramStore.getParameter("location"));
        params.add(CatalogConfig.paramStore.getParameter("longitude"));
        params.add(CatalogConfig.paramStore.getParameter("latitude"));
        params.add(CatalogConfig.paramStore.getParameter("event_type"));
        params.add(CatalogConfig.paramStore.resolveOrCreateParameter("srs_list_fs", (GenericData)CatalogConfig.typesFactory.getType("type_noaa_srs_feature_fs").newData(), noaaSRSCat));
        CatalogConfig.paramStore.resolveOrCreateParameter("srs_list", (GenericData)CatalogConfig.typesFactory.getType("type_noaa_srs_feature_list").newData(), noaaSRSCat);
        Result srsArsResultQs = CatalogConfig.paramStore.resolveOrCreateResult("srs_list_qs", CatalogConfig.typesFactory.getType("type_query_source"), noaaSRSCat);
        Result srsArsResult = CatalogConfig.paramStore.resolveOrCreateResult("srs_list", CatalogConfig.typesFactory.getType("type_noaa_srs_feature_list"), noaaSRSCat);
        Iterator iter = params.iterator();
        while (iter.hasNext()) {
            Parameter param = (Parameter)((Object)iter.next());
            srsArsResultQs.addDependsOn(param);
        }
        CatalogConfig.paramStore.resolveOrCreateParameter("event-plot-srs_list-length", (GenericData)CatalogConfig.typesFactory.getType("type_integer").newData("20000"), noaaSRSCat);
        srsArsResultQs.setUpdator(new QuerySourceUpdator(){

            public Data update(GenericQuery q, AbstractParameter param) throws ConsumerException {
                Data eventType = q.get("event_type");
                if (q.isSet("event_type") && !eventType.id().equals("srs_list")) {
                    throw new ConsumerException("illegal event type '" + eventType.id() + "' for result '" + param.getDataKey() + "'");
                }
                if (eventType.id() == null) {
                    q.setValue("event_type", "srs_list");
                }
                Data superret = super.update(q, param);
                if (eventType.id() == null) {
                    q.unset("event_type");
                }
                return superret;
            }

            protected void xmlQuery(Document queryDoc, GenericQuery q, AbstractParameter param) throws ConsumerException {
                super.xmlQuery(queryDoc, q, param);
                queryDoc.getDocumentElement().getElementsByTagName("data").item(0).getAttributes().getNamedItem("type").setNodeValue("event");
            }
        });
        srsArsResult.addDependsOn(srsArsResultQs);
        srsArsResult.setUpdator(new RemoteUpdator("srs_list_qs"){

            protected void postprocessing(GenericQuery q, AbstractParameter param, Data vod) throws ArgumentException, ConsumerException {
                if (q.isSet("prefetch-plot-type")) {
                    String plotSelect = q.get("prefetch-plot-type").id();
                    vod.put(plotSelect, q.getResult(plotSelect));
                }
                int nSecs = 0;
                try {
                    Data nData = q.get("event-plot-srs_list-length");
                    nSecs = (Integer)nData.getValue();
                }
                catch (Exception ex) {
                    nSecs = 20000;
                }
                Iterator it = vod.elements().iterator();
                while (it.hasNext()) {
                    String startdateid;
                    Data flare = (Data)it.next();
                    Data startDate = flare.get("time_start");
                    String enddateid = startdateid = startDate.id();
                    Calendar newStartDate = (Calendar)((Calendar)startDate.getValue()).clone();
                    Calendar newEndDate = (Calendar)newStartDate.clone();
                    newStartDate.add(13, -nSecs / 2);
                    newEndDate.add(13, nSecs / 2);
                    String newstarttimeid = startDate.newData(newStartDate).id();
                    String newendtimeid = startDate.newData(newEndDate).id();
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug((Object)("time range for srs_list plots set to " + newstarttimeid + " - " + newendtimeid));
                    }
                    startdateid = newstarttimeid;
                    enddateid = newendtimeid;
                    Data xrayPlot = ((Type)flare.childrenTypes().get("goes-plot-xray")).newData();
                    xrayPlot.setValue(new LazyCosecImageData.CosecCallArguments(startdateid, enddateid, 2));
                    flare.put("goes-plot-xray", xrayPlot);
                    Data protonPlot = ((Type)flare.childrenTypes().get("goes-plot-proton")).newData();
                    protonPlot.setValue(new LazyCosecImageData.CosecCallArguments(startdateid, enddateid, 1));
                    flare.put("goes-plot-proton", protonPlot);
                }
            }
        });
    }
}

