/*
 * Decompiled with CFR 0.152.
 */
package org.egso.consumer.config;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.egso.consumer.QueryLiterals;
import org.egso.consumer.api.ConsumerException;
import org.egso.consumer.api.Data;
import org.egso.consumer.config.CatalogConfig;
import org.egso.consumer.core.AbstractCatalogue;
import org.egso.consumer.core.AbstractParameter;
import org.egso.consumer.core.GenericData;
import org.egso.consumer.core.GenericQuery;
import org.egso.consumer.core.GenericType;
import org.egso.consumer.core.Parameter;
import org.egso.consumer.core.Result;
import org.egso.consumer.core.Updator;
import org.egso.consumer.remotequery.FieldSelectorFactory;
import org.egso.consumer.remotequery.QuerySourceUpdator;
import org.egso.consumer.remotequery.RemoteUpdator;
import org.egso.consumer.types.votable.VOTableData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ObservationConfig
extends CatalogConfig
implements QueryLiterals {
    public ObservationConfig() {
        super("observation");
    }

    public List getTypes() throws ConsumerException {
        ArrayList<GenericType> types = new ArrayList<GenericType>();
        GenericType obsType = new GenericType("type_observation");
        obsType.childrenTypes().put("date", CatalogConfig.typesFactory.getType("type_date_interval"));
        obsType.childrenTypes().put("time_start", CatalogConfig.typesFactory.getType("type_date"));
        obsType.childrenTypes().put("time_end", CatalogConfig.typesFactory.getType("type_date"));
        obsType.childrenTypes().put("instrument", CatalogConfig.typesFactory.getType("type_instrument_list").elementsType());
        obsType.childrenTypes().put("observatory", CatalogConfig.typesFactory.getType("type_observatory_list").elementsType());
        obsType.childrenTypes().put("observable_entity_type", CatalogConfig.typesFactory.getType("type_observable_entity_type_list").elementsType());
        VOTableData.VOTableType obsListResultType = new VOTableData.VOTableType("type_observation_list", new String[]{"date", "instrument"});
        obsListResultType.setElemsType(obsType);
        obsListResultType.childrenTypes().put("goes-plot-proton", CatalogConfig.typesFactory.getType("type_plot_type"));
        obsListResultType.childrenTypes().put("goes-plot-xray", CatalogConfig.typesFactory.getType("type_plot_type"));
        obsListResultType.childrenTypes().put("context", CatalogConfig.typesFactory.getType("type_context"));
        obsListResultType.setEnum(true);
        GenericType fsType = CatalogConfig.fsFactory.createFieldSelectorType("observation", "type_observation_fs", new FieldSelectorFactory.FSEntry[]{new FieldSelectorFactory.FSEntry("observatory", 1), new FieldSelectorFactory.FSEntry("instrument", 1), new FieldSelectorFactory.FSEntry("time_start", 3), new FieldSelectorFactory.FSEntry("time_end", 3), new FieldSelectorFactory.FSEntry("observable_entity_type", 1)});
        types.add(obsType);
        types.add(obsListResultType);
        types.add(fsType);
        return types;
    }

    public void initParameters() throws ConsumerException {
        AbstractCatalogue obsCat = AbstractCatalogue.resolveOrCreateCatalogue("observation");
        CatalogConfig.paramStore.resolveOrCreateParameter("observation", (GenericData)CatalogConfig.typesFactory.getType("type_observation_list").newData(), obsCat);
        ArrayList<Parameter> resultDep = new ArrayList<Parameter>();
        resultDep.add(CatalogConfig.paramStore.resolveOrCreateParameter("date", CatalogConfig.typesFactory.getType("type_date_interval"), obsCat));
        resultDep.add(CatalogConfig.paramStore.resolveOrCreateParameter("observation_fs", (GenericData)CatalogConfig.typesFactory.getType("type_observation_fs").newData(), obsCat));
        resultDep.add(CatalogConfig.paramStore.getParameter("instrument"));
        Parameter oeType = CatalogConfig.paramStore.getParameter("observable_entity_type");
        resultDep.add(oeType);
        oeType.addDependsOn(CatalogConfig.paramStore.getParameter("observable_entity_type_insitu"));
        oeType.addDependsOn(CatalogConfig.paramStore.getParameter("observable_entity_type_remote"));
        oeType.setUpdator(new Updator(){

            public Data update(GenericQuery q, AbstractParameter param) throws ConsumerException {
                Data oeTypeList = param.getType().newData();
                String[] oeTypes = new String[]{"observable_entity_type_insitu", "observable_entity_type_remote"};
                int i = 0;
                while (i < oeTypes.length) {
                    if (q.isSet(oeTypes[i])) {
                        Iterator iter = q.get(oeTypes[i]).elements().iterator();
                        while (iter.hasNext()) {
                            Data oeType = (Data)iter.next();
                            oeTypeList.add(oeType);
                        }
                    }
                    ++i;
                }
                if (oeTypeList.elements().size() > 0) {
                    return oeTypeList;
                }
                return null;
            }
        });
        resultDep.add(CatalogConfig.paramStore.getParameter("goes_xray_flare"));
        resultDep.add(CatalogConfig.paramStore.getParameter("noaa_proton_event"));
        resultDep.add(CatalogConfig.paramStore.getParameter("srs_list"));
        resultDep.add(CatalogConfig.paramStore.getParameter("votable_ingest"));
        Result obsResultQs = CatalogConfig.paramStore.resolveOrCreateResult("observation_qs", CatalogConfig.typesFactory.getType("type_query_source"), obsCat);
        Result obsResult = CatalogConfig.paramStore.resolveOrCreateResult("observation", CatalogConfig.typesFactory.getType("type_observation_list"));
        Iterator iter = resultDep.iterator();
        while (iter.hasNext()) {
            AbstractParameter param = (AbstractParameter)((Object)iter.next());
            param.addCatalogue(obsCat);
            obsResultQs.addDependsOn(param);
        }
        obsResult.addDependsOn(obsResultQs);
        obsResultQs.setUpdator(new QuerySourceUpdator(){

            protected void xmlQuery(Document queryDoc, GenericQuery q, AbstractParameter param) throws ConsumerException {
                super.xmlQuery(queryDoc, q, param);
                Element data = (Element)queryDoc.getDocumentElement().getElementsByTagName("data").item(0);
                NodeList dataChildren = data.getChildNodes();
                ArrayList<Node> groupTags = new ArrayList<Node>();
                int i = 0;
                while (i < dataChildren.getLength()) {
                    Node current = dataChildren.item(i);
                    if (current instanceof Element && "group".equals(current.getNodeName())) {
                        groupTags.add(current);
                    }
                    ++i;
                }
                ArrayList<Node> paramTags = new ArrayList<Node>();
                int i2 = 0;
                while (i2 < dataChildren.getLength()) {
                    Node current = dataChildren.item(i2);
                    if (current instanceof Element && "param".equals(current.getNodeName())) {
                        if (groupTags.size() > 0 && "date".equals(((Element)current).getAttribute("name"))) {
                            data.removeChild(current);
                        } else {
                            paramTags.add(current);
                        }
                    }
                    ++i2;
                }
                if (groupTags.size() > 0 && paramTags.size() > 0) {
                    Element groupTag = queryDoc.createElement("group");
                    groupTag.setAttribute("relation", "OR");
                    Iterator iter = groupTags.iterator();
                    while (iter.hasNext()) {
                        Node current = (Node)iter.next();
                        data.removeChild(current);
                        groupTag.appendChild(current);
                    }
                    data.appendChild(groupTag);
                } else if (groupTags.size() > 0) {
                    data.setAttribute("relation", "OR");
                }
            }
        });
        obsResult.setUpdator(new RemoteUpdator("observation_qs"));
    }
}

