/*
 * Decompiled with CFR 0.152.
 */
package org.egso.consumer.config;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.egso.consumer.api.ConsumerException;
import org.egso.consumer.api.Data;
import org.egso.consumer.api.ParameterRequiredException;
import org.egso.consumer.api.ScalarData;
import org.egso.consumer.config.CatalogConfig;
import org.egso.consumer.core.AbstractCatalogue;
import org.egso.consumer.core.AbstractParameter;
import org.egso.consumer.core.GenericQuery;
import org.egso.consumer.core.Result;
import org.egso.consumer.core.Updator;
import org.egso.consumer.plot.LazyCosecImageData;
import org.egso.consumer.types.IntervalData;
import org.egso.consumer.types.egso.EGSOTypesFactory;

public class PlotConfig
extends CatalogConfig
implements Updator {
    public PlotConfig() {
        super("cosec_plot");
    }

    public List getTypes() {
        return new ArrayList();
    }

    public void initParameters() throws ConsumerException {
        AbstractCatalogue plotCat = AbstractCatalogue.resolveOrCreateCatalogue("cosec_plot");
        Result plotXrayResult = CatalogConfig.paramStore.resolveOrCreateResult("goes-plot-xray", CatalogConfig.typesFactory.getType("type_plot_type"), plotCat);
        Result plotProtonResult = CatalogConfig.paramStore.resolveOrCreateResult("goes-plot-proton", CatalogConfig.typesFactory.getType("type_plot_type"), plotCat);
        plotXrayResult.addDependsOn(CatalogConfig.paramStore.getParameter("date"));
        plotXrayResult.setUpdator(this);
        plotProtonResult.addDependsOn(CatalogConfig.paramStore.getParameter("date"));
        plotProtonResult.setUpdator(this);
    }

    public Data update(GenericQuery query, AbstractParameter param) throws ConsumerException {
        String dataKey = param.getDataKey();
        int plotType = 2;
        if (dataKey.startsWith("goes-plot-proton")) {
            plotType = 1;
        }
        if (dataKey.startsWith("goes-plot-xray")) {
            plotType = 2;
        }
        IntervalData date = (IntervalData)query.get("date");
        ScalarData min = date.getMin();
        ScalarData max = date.getMax();
        if (min == null || max == null) {
            LinkedList<String> missingParams = new LinkedList<String>();
            missingParams.add("date");
            throw new ParameterRequiredException(dataKey, missingParams, "NOTE: the '" + dataKey + "' result requires a closed interval " + "of dates in the '" + "date" + "' parameter" + (min == null ? "; lower bounds of intervall missing" : "") + (max == null ? "; upper bounds of intervall missing" : ""));
        }
        String startDate = min.id();
        String endDate = max.id();
        Data plot = EGSOTypesFactory.getInstance().getType("type_plot_type").newData(new LazyCosecImageData.CosecCallArguments(startDate, endDate, plotType));
        return plot;
    }
}

