/*
 * Decompiled with CFR 0.152.
 */
package org.egso.consumer.config;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.egso.consumer.EGSOLiterals;
import org.egso.consumer.api.ConsumerException;
import org.egso.consumer.api.Data;
import org.egso.consumer.config.CatalogConfig;
import org.egso.consumer.config.EventsConfig;
import org.egso.consumer.core.AbstractCatalogue;
import org.egso.consumer.core.AbstractParameter;
import org.egso.consumer.core.GenericData;
import org.egso.consumer.core.GenericQuery;
import org.egso.consumer.core.GenericType;
import org.egso.consumer.core.Parameter;
import org.egso.consumer.core.Result;
import org.egso.consumer.core.Updator;
import org.egso.consumer.types.votable.VOTableData;

public class VOTableIngestionConfig
extends EventsConfig
implements EGSOLiterals {
    public VOTableIngestionConfig() {
        super("cat_votable_ingest");
    }

    public List getTypes() throws ConsumerException {
        ArrayList<GenericType> types = new ArrayList<GenericType>();
        GenericType eventCatType = CatalogConfig.typesFactory.getType("type_event_type");
        Data eventCatFlare = eventCatType.newData();
        ((GenericData)eventCatFlare).setId("cat_votable_ingest");
        eventCatType.valueDomain().add(eventCatFlare);
        GenericType votableIngestType = new GenericType("type_votable_ingest");
        votableIngestType.childrenTypes().put("date", CatalogConfig.typesFactory.getType("type_date_interval"));
        votableIngestType.childrenTypes().put("time_start", CatalogConfig.typesFactory.getType("type_date"));
        votableIngestType.childrenTypes().put("time_end", CatalogConfig.typesFactory.getType("type_date"));
        votableIngestType.childrenTypes().put("location", CatalogConfig.typesFactory.getType("type_pointing"));
        votableIngestType.childrenTypes().put("longitude", CatalogConfig.typesFactory.getType("type_coord"));
        votableIngestType.childrenTypes().put("latitude", CatalogConfig.typesFactory.getType("type_coord"));
        votableIngestType.childrenTypes().put("goes-plot-xray", CatalogConfig.typesFactory.getType("type_plot_type"));
        votableIngestType.childrenTypes().put("goes-plot-proton", CatalogConfig.typesFactory.getType("type_plot_type"));
        VOTableData.VOTableType votableIngestListType = new VOTableData.VOTableType("type_votable_ingest_list", new String[]{"date"});
        votableIngestListType.setElemsType(votableIngestType);
        votableIngestListType.childrenTypes().put("goes-plot-proton", CatalogConfig.typesFactory.getType("type_plot_type"));
        votableIngestListType.childrenTypes().put("goes-plot-xray", CatalogConfig.typesFactory.getType("type_plot_type"));
        votableIngestListType.setEnum(true);
        types.add(votableIngestType);
        types.add(votableIngestListType);
        return types;
    }

    public void initParameters() throws ConsumerException {
        AbstractCatalogue votablIngestCat = AbstractCatalogue.resolveOrCreateCatalogue("cat_votable_ingest");
        ArrayList<Parameter> params = new ArrayList<Parameter>();
        params.add(CatalogConfig.paramStore.resolveOrCreateParameter("date", CatalogConfig.typesFactory.getType("type_date_interval"), votablIngestCat));
        params.add(CatalogConfig.paramStore.resolveOrCreateParameter("time_start", CatalogConfig.typesFactory.getType("type_date"), votablIngestCat));
        params.add(CatalogConfig.paramStore.resolveOrCreateParameter("time_end", CatalogConfig.typesFactory.getType("type_date"), votablIngestCat));
        params.add(CatalogConfig.paramStore.resolveOrCreateParameter("location", CatalogConfig.typesFactory.getType("type_pointing"), votablIngestCat));
        params.add(CatalogConfig.paramStore.resolveOrCreateParameter("longitude", CatalogConfig.typesFactory.getType("type_coord"), votablIngestCat));
        params.add(CatalogConfig.paramStore.resolveOrCreateParameter("latitude", CatalogConfig.typesFactory.getType("type_coord"), votablIngestCat));
        params.add(CatalogConfig.paramStore.resolveOrCreateParameter("votable_ingest", (GenericData)CatalogConfig.typesFactory.getType("type_votable_ingest_list").newData(), votablIngestCat));
        Result votableIngestResult = CatalogConfig.paramStore.resolveOrCreateResult("votable_ingest", CatalogConfig.typesFactory.getType("type_votable_ingest_list"), votablIngestCat);
        Iterator iter = params.iterator();
        while (iter.hasNext()) {
            Parameter param = (Parameter)((Object)iter.next());
            votableIngestResult.addDependsOn(param);
        }
        votableIngestResult.setUpdator(new Updator(){

            public Data update(GenericQuery q, AbstractParameter param) throws ConsumerException {
                Parameter selectionParam = CatalogConfig.paramStore.getParameter(param.getDataKey());
                GenericData selection = q.getQueryData(selectionParam).getData();
                Data result = q.getQueryData(param).getData();
                if (result == null || selection.getValue() != null && !selection.getValue().equals(result.getValue())) {
                    result = (Data)selection.clone();
                    selection.elements().clear();
                }
                return result;
            }
        });
    }
}

