/*
 * Decompiled with CFR 0.152.
 */
package org.egso.consumer.core;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.egso.common.logging.AbstractLogEnabled;
import org.egso.consumer.api.ArgumentException;
import org.egso.consumer.core.AbstractParameter;
import org.egso.consumer.core.Parameter;
import org.egso.consumer.core.ParameterStore;
import org.egso.consumer.core.Result;
import org.egso.consumer.valid.CatNameValidator;

public class AbstractCatalogue
extends AbstractLogEnabled {
    private static final Map allCatalogues = Collections.synchronizedMap(new HashMap());
    private final String name;
    private final Set params = Collections.synchronizedSet(new HashSet());

    public static AbstractCatalogue resolveCatalogue(String cat_name) {
        return (AbstractCatalogue)((Object)allCatalogues.get(cat_name));
    }

    public static AbstractCatalogue resolveOrCreateCatalogue(String cat_name) throws ArgumentException {
        AbstractCatalogue c = AbstractCatalogue.resolveCatalogue(cat_name);
        if (c == null) {
            c = new AbstractCatalogue(cat_name);
        }
        return c;
    }

    public static Set allCatalogues() {
        return new HashSet(allCatalogues.values());
    }

    private AbstractCatalogue(String name) throws ArgumentException {
        CatNameValidator.validateCatalogueName(name);
        if (allCatalogues.put(name, this) != null) {
            throw new ArgumentException("catalogue already exists with the same name");
        }
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Set getParameters() {
        return this.params;
    }

    public boolean addParameter(AbstractParameter param) {
        boolean r = this.params.add(param);
        if (!param.getCatalogues().contains((Object)this)) {
            param.getCatalogues().add(this);
        }
        return r;
    }

    public boolean addParameter(String data_key) {
        return this.addParameter(ParameterStore.getInstance().getParameter(data_key));
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    private Collection getParameterNames() {
        LinkedList<String> pn = new LinkedList<String>();
        Iterator it = this.getParameters().iterator();
        while (it.hasNext()) {
            AbstractParameter p = (AbstractParameter)((Object)it.next());
            if (p instanceof Parameter) {
                pn.add("parameter::" + p.getDataKey());
                continue;
            }
            if (p instanceof Result) {
                pn.add("result::" + p.getDataKey());
                continue;
            }
            pn.add("::" + p.getDataKey());
        }
        return pn;
    }

    public String toString() {
        return "AbstractCatalogue(name=" + this.getName() + " parameters=" + this.getParameterNames() + ")";
    }

    public static synchronized void reset() {
        Iterator cit = new LinkedList(allCatalogues.values()).iterator();
        while (cit.hasNext()) {
            AbstractCatalogue ac = (AbstractCatalogue)((Object)cit.next());
            Iterator pit = new LinkedList(ac.params).iterator();
            while (pit.hasNext()) {
                AbstractParameter p = (AbstractParameter)((Object)pit.next());
                p.removeCatalogue(ac);
            }
        }
        allCatalogues.clear();
    }
}

