/*
 * Decompiled with CFR 0.152.
 */
package org.egso.consumer.core;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.egso.common.logging.AbstractLogEnabled;
import org.egso.consumer.api.ArgumentException;
import org.egso.consumer.api.Data;
import org.egso.consumer.api.Type;
import org.egso.consumer.core.AbstractCatalogue;
import org.egso.consumer.core.GenericData;
import org.egso.consumer.core.GenericType;
import org.egso.consumer.core.ParameterStore;
import org.egso.consumer.core.Updator;
import org.egso.consumer.valid.DataKeyValidator;

public abstract class AbstractParameter
extends AbstractLogEnabled {
    private final String data_key;
    private boolean readonly = false;
    private final GenericType type;
    private Set dependsOn = Collections.synchronizedSet(new HashSet());
    private Data initValue = null;
    private Updator updator = null;
    private final int hashCode;
    private Set catalogues = Collections.synchronizedSet(new HashSet());

    protected AbstractParameter(String data_key, GenericType type) throws ArgumentException {
        DataKeyValidator.validateDataKey(data_key);
        this.data_key = data_key;
        if (type == null) {
            ArgumentException aex = new ArgumentException("type expected instead of null");
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)aex);
            }
            throw aex;
        }
        this.type = type;
        this.hashCode = data_key.hashCode() + ((Object)((Object)this)).getClass().hashCode();
        this.getLogger().debug((Object)(String.valueOf(((Object)((Object)this)).getClass().getName()) + " '" + data_key + "' created with type " + type));
    }

    protected AbstractParameter(String data_key, GenericData initData) throws ArgumentException {
        this(data_key, (GenericType)initData.type());
        this.setInitValue(this.initValue);
    }

    public String getDataKey() {
        return this.data_key;
    }

    public synchronized boolean isReadonly() {
        return this.readonly;
    }

    public synchronized void setReadonly(boolean b) {
        this.readonly = b;
    }

    public Set getDependsOn() {
        return this.dependsOn;
    }

    public boolean addDependsOn(AbstractParameter ap) {
        return this.getDependsOn().add(ap);
    }

    public Set getDependOnThis() {
        HashSet<AbstractParameter> depend = new HashSet<AbstractParameter>();
        Collection all = ParameterStore.getInstance().getAllParametersAndResults();
        Iterator allit = all.iterator();
        while (allit.hasNext()) {
            AbstractParameter ap = (AbstractParameter)((Object)allit.next());
            if (!ap.dependsOn.contains((Object)this)) continue;
            depend.add(ap);
        }
        return depend;
    }

    public Type getType() {
        return this.type;
    }

    public synchronized Updator getUpdator() {
        return this.updator;
    }

    public synchronized void setUpdator(Updator updator) {
        this.updator = updator;
    }

    public boolean equals(Object otherParameter) {
        if (!(otherParameter instanceof AbstractParameter)) {
            return false;
        }
        return this.getDataKey().equals(((AbstractParameter)((Object)otherParameter)).getDataKey()) && ((Object)((Object)this)).getClass().equals(otherParameter.getClass());
    }

    public int hashCode() {
        return this.hashCode;
    }

    public synchronized String toString() {
        return "AbstractParameter(data_key=" + this.getDataKey() + " readonly=" + this.isReadonly() + " type=" + this.getType() + " dependsOn=" + this.getDependsOn() + " catalogues=" + this.catalogues + ")";
    }

    public Set getCatalogues() {
        return this.catalogues;
    }

    public boolean addCatalogue(AbstractCatalogue cat) {
        boolean r = this.getCatalogues().add(cat);
        if (!cat.getParameters().contains((Object)this)) {
            cat.getParameters().add(this);
        }
        return r;
    }

    public final boolean addCatalogue(String cat_name) throws ArgumentException {
        return this.addCatalogue(AbstractCatalogue.resolveOrCreateCatalogue(cat_name));
    }

    public boolean removeCatalogue(AbstractCatalogue cat) {
        boolean r = this.getCatalogues().remove((Object)cat);
        if (cat.getParameters().contains((Object)this)) {
            cat.getParameters().remove((Object)this);
        }
        return r;
    }

    public final boolean removeCatalogue(String cat_name) throws ArgumentException {
        return this.removeCatalogue(AbstractCatalogue.resolveOrCreateCatalogue(cat_name));
    }

    public synchronized Data getInitValue() {
        return this.initValue;
    }

    public synchronized void setInitValue(Data initValue) {
        this.initValue = initValue;
    }
}

