/*
 * Decompiled with CFR 0.152.
 */
package org.egso.consumer.core;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.egso.common.context.EGSOContext;
import org.egso.common.logging.AbstractLogEnabled;
import org.egso.consumer.api.ArgumentException;
import org.egso.consumer.api.ConsumerException;
import org.egso.consumer.api.Data;
import org.egso.consumer.api.Query;
import org.egso.consumer.api.Type;
import org.egso.consumer.core.AbstractCatalogue;
import org.egso.consumer.core.AbstractParameter;
import org.egso.consumer.core.GenericData;
import org.egso.consumer.core.Parameter;
import org.egso.consumer.core.ParameterStore;
import org.egso.consumer.core.QueryData;
import org.egso.consumer.core.Result;
import org.egso.consumer.types.QuerySourceData;
import org.egso.consumer.valid.CatNameValidator;
import org.egso.consumer.valid.DataKeyValidator;

public class GenericQuery
extends AbstractLogEnabled
implements Query {
    private String id = "Q" + this.hashCode();
    private Map params = new HashMap();
    private long modCount = 0L;
    private static final ParameterStore pStore = ParameterStore.getInstance();

    private static Parameter getParameterFromStore(String data_key) throws ArgumentException {
        DataKeyValidator.validateDataKey(data_key);
        Parameter p = pStore.getParameter(data_key);
        if (p == null) {
            throw new ArgumentException("parameter '" + data_key + "' not found");
        }
        return p;
    }

    private static AbstractCatalogue getCatalogueFromStore(String catalogue_key) throws ArgumentException {
        CatNameValidator.validateCatalogueName(catalogue_key);
        return AbstractCatalogue.resolveCatalogue(catalogue_key);
    }

    private static Result getResultFromStore(String data_key) throws ArgumentException {
        DataKeyValidator.validateDataKey(data_key);
        Result r = pStore.getResult(data_key);
        if (r == null) {
            throw new ArgumentException("result '" + data_key + "' not found");
        }
        return r;
    }

    private static Set abstractparams2names(Collection params) {
        TreeSet<String> ret = new TreeSet<String>();
        Iterator pit = params.iterator();
        while (pit.hasNext()) {
            AbstractParameter p = (AbstractParameter)((Object)pit.next());
            ret.add(p.getDataKey());
        }
        return ret;
    }

    private static Set parameters2names(Collection params) {
        TreeSet<String> ret = new TreeSet<String>();
        Iterator pit = params.iterator();
        while (pit.hasNext()) {
            AbstractParameter p = (AbstractParameter)((Object)pit.next());
            if (!(p instanceof Parameter)) continue;
            ret.add(p.getDataKey());
        }
        return ret;
    }

    private static Set results2names(Collection results) {
        TreeSet<String> ret = new TreeSet<String>();
        Iterator pit = results.iterator();
        while (pit.hasNext()) {
            AbstractParameter p = (AbstractParameter)((Object)pit.next());
            if (!(p instanceof Result)) continue;
            ret.add(p.getDataKey());
        }
        return ret;
    }

    public synchronized Collection catalogues() {
        TreeSet<String> cats = new TreeSet<String>();
        Iterator it = AbstractCatalogue.allCatalogues().iterator();
        while (it.hasNext()) {
            AbstractCatalogue cat = (AbstractCatalogue)((Object)it.next());
            cats.add(cat.getName());
        }
        return cats;
    }

    public Collection findParametersByCatalogue(String catalogue_key) throws ArgumentException {
        return GenericQuery.parameters2names(GenericQuery.getCatalogueFromStore(catalogue_key).getParameters());
    }

    public Collection findResultsByCatalogue(String catalogue_key) throws ArgumentException {
        return GenericQuery.results2names(GenericQuery.getCatalogueFromStore(catalogue_key).getParameters());
    }

    public synchronized Collection findAll() {
        return GenericQuery.abstractparams2names(pStore.getAllParametersAndResults());
    }

    public Collection findAllParameters() {
        return GenericQuery.parameters2names(pStore.getAllParameters());
    }

    public Collection findAllResults() {
        return GenericQuery.results2names(pStore.getAllResults());
    }

    public Collection affectedBy(String data_key) throws ArgumentException {
        boolean isParam = this.findAllParameters().contains(data_key);
        boolean isResult = this.findAllResults().contains(data_key);
        if (!isParam && !isResult) {
            throw new ArgumentException("'" + data_key + "' not found");
        }
        TreeSet dep = new TreeSet();
        if (isParam) {
            dep.addAll(GenericQuery.abstractparams2names(GenericQuery.getParameterFromStore(data_key).getDependOnThis()));
        }
        if (isResult) {
            dep.addAll(GenericQuery.abstractparams2names(GenericQuery.getResultFromStore(data_key).getDependOnThis()));
        }
        return dep;
    }

    public Collection parametersAffectedByParameter(String data_key) throws ArgumentException {
        return GenericQuery.parameters2names(GenericQuery.getParameterFromStore(data_key).getDependsOn());
    }

    public Collection parametersAffectedByResult(String data_key) throws ArgumentException {
        return GenericQuery.parameters2names(GenericQuery.getResultFromStore(data_key).getDependsOn());
    }

    public Collection resultsAffectedByParameter(String data_key) throws ArgumentException {
        return GenericQuery.results2names(GenericQuery.getParameterFromStore(data_key).getDependsOn());
    }

    public Collection resultsAffectedByResult(String data_key) throws ArgumentException {
        return GenericQuery.results2names(GenericQuery.getResultFromStore(data_key).getDependsOn());
    }

    public Collection affect(String data_key) throws ArgumentException {
        boolean isParam = this.findAllParameters().contains(data_key);
        boolean isResult = this.findAllResults().contains(data_key);
        if (!isParam && !isResult) {
            throw new ArgumentException("'" + data_key + "' not found");
        }
        TreeSet dep = new TreeSet();
        if (isParam) {
            dep.addAll(GenericQuery.abstractparams2names(GenericQuery.getParameterFromStore(data_key).getDependsOn()));
        }
        if (isResult) {
            dep.addAll(GenericQuery.abstractparams2names(GenericQuery.getResultFromStore(data_key).getDependsOn()));
        }
        return dep;
    }

    public Collection parametersAffectParameter(String data_key) throws ArgumentException {
        return GenericQuery.parameters2names(GenericQuery.getParameterFromStore(data_key).getDependOnThis());
    }

    public Collection parametersAffectResult(String data_key) throws ArgumentException {
        return GenericQuery.parameters2names(GenericQuery.getResultFromStore(data_key).getDependOnThis());
    }

    public Collection resultsAffectParameter(String data_key) throws ArgumentException {
        return GenericQuery.results2names(GenericQuery.getParameterFromStore(data_key).getDependOnThis());
    }

    public Collection resultsAffectResult(String data_key) throws ArgumentException {
        return GenericQuery.results2names(GenericQuery.getResultFromStore(data_key).getDependOnThis());
    }

    public Type getParameterType(String data_key) throws ArgumentException {
        return GenericQuery.getParameterFromStore(data_key).getType();
    }

    public Type getResultType(String data_key) throws ArgumentException {
        return GenericQuery.getResultFromStore(data_key).getType();
    }

    public void setId(String newId) {
        this.id = newId;
    }

    public String id() {
        return this.id;
    }

    public synchronized QueryData getQueryData(AbstractParameter ap) {
        return (QueryData)((Object)this.params.get((Object)ap));
    }

    public synchronized QueryData getOrCreateQueryData(AbstractParameter ap) {
        QueryData qd = this.getQueryData(ap);
        if (qd != null) {
            return qd;
        }
        qd = new QueryData(this, ap);
        this.params.put(ap, qd);
        return qd;
    }

    public synchronized long getModCount() {
        return this.modCount;
    }

    public synchronized long incModCount() {
        return this.modCount++;
    }

    public boolean updateParameter(String data_key) throws ArgumentException, ConsumerException {
        QueryData qd = this.getOrCreateQueryData(GenericQuery.getParameterFromStore(data_key));
        qd.makeDirty();
        return qd.update();
    }

    public boolean updateResult(String data_key) throws ArgumentException, ConsumerException {
        QueryData qd = this.getOrCreateQueryData(GenericQuery.getResultFromStore(data_key));
        qd.makeDirty();
        return qd.update();
    }

    public Data get(String data_key) throws ArgumentException, ConsumerException {
        Parameter param;
        Data data;
        QueryData qd = this.getOrCreateQueryData(GenericQuery.getParameterFromStore(data_key));
        if (qd.dirty()) {
            this.updateParameter(data_key);
        }
        if ((data = this.getQueryData(param = GenericQuery.getParameterFromStore(data_key)).getData()) == null) {
            data = param.getType().newData();
        }
        return data;
    }

    public Data getResult(String data_key) throws ConsumerException {
        QueryData qd = this.getOrCreateQueryData(GenericQuery.getResultFromStore(data_key));
        if (qd.dirty()) {
            this.updateResult(data_key);
        }
        return qd.getData();
    }

    public synchronized void set(String data_key, Data value) throws ArgumentException, ConsumerException {
        if (value == null) {
            this.unset(data_key);
        } else {
            if (!value.readonly()) {
                value = (Data)((GenericData)value).clone();
            }
            this.getOrCreateQueryData(GenericQuery.getParameterFromStore(data_key)).setData((GenericData)value);
        }
    }

    public synchronized void setValue(String data_key, Object value) throws ArgumentException, ConsumerException {
        if (value == null) {
            this.unset(data_key);
        } else if (value instanceof Data) {
            this.set(data_key, (Data)value);
        } else {
            this.getOrCreateQueryData(GenericQuery.getParameterFromStore(data_key)).setValue(value);
        }
    }

    public boolean isSet(String data_key) throws ArgumentException {
        QueryData qd = this.getQueryData(GenericQuery.getParameterFromStore(data_key));
        if (qd == null) {
            return false;
        }
        return qd.isSet();
    }

    public void unset(String data_key) throws ArgumentException, ConsumerException {
        QueryData qd = this.getQueryData(GenericQuery.getParameterFromStore(data_key));
        if (qd == null) {
            return;
        }
        qd.unset();
    }

    public String getQuerySource(String data_key) throws ArgumentException, ConsumerException {
        Result result = GenericQuery.getResultFromStore(data_key);
        Iterator iter = result.getDependsOn().iterator();
        while (iter.hasNext()) {
            AbstractParameter dependency = (AbstractParameter)((Object)iter.next());
            if (!(dependency.getType() instanceof QuerySourceData.QuerySourceType)) continue;
            return (String)this.getResult(dependency.getDataKey()).getValue();
        }
        return null;
    }

    public EGSOContext getContext(String data_key) throws ConsumerException {
        QueryData result = this.getQueryData(GenericQuery.getResultFromStore(data_key));
        if (result == null) {
            return null;
        }
        GenericData data = result.getData();
        if (data == null) {
            return null;
        }
        Data context = (Data)data.children().get("context");
        if (context == null) {
            return null;
        }
        return (EGSOContext)context.getValue();
    }
}

