/*
 * Decompiled with CFR 0.152.
 */
package org.egso.consumer.core;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.egso.common.logging.AbstractLogEnabled;
import org.egso.consumer.api.ArgumentException;
import org.egso.consumer.api.ConsumerException;
import org.egso.consumer.api.Data;
import org.egso.consumer.api.ImmutableException;
import org.egso.consumer.api.Interval;
import org.egso.consumer.api.Type;
import org.egso.consumer.core.GenericData;
import org.egso.consumer.core.GenericType;
import org.egso.consumer.core.UncheckedConsumerException;
import org.egso.consumer.valid.ChildNameValidator;
import org.egso.consumer.valid.TypeNameValidator;

public class GenericType
extends AbstractLogEnabled
implements Type,
Cloneable {
    private boolean immutable = false;
    private boolean enumValue = false;
    private HashMap childrenTypes = null;
    private GenericType elemsType = null;
    private GenericData neutral_data = null;
    private final String typeName;
    private String ucd = null;
    private String unit = null;
    private GenericData valueDomain = null;
    private boolean distinct = true;

    private synchronized void initChildrenTypes(Map initialMap) {
        if (this.childrenTypes != null) {
            return;
        }
        class ChildrenHashMap
        extends HashMap {
            final /* synthetic */ GenericType this$0;

            public ChildrenHashMap(GenericType genericType) {
                this.this$0 = genericType;
            }

            public ChildrenHashMap(GenericType genericType, Map map) {
                super(map);
                this.this$0 = genericType;
            }

            public Object put(Object key, Object val) {
                GenericType genericType = this.this$0;
                synchronized (genericType) {
                    try {
                        this.this$0.checkMutable();
                    }
                    catch (ImmutableException ex) {
                        throw new UncheckedConsumerException(ex);
                    }
                    try {
                        ChildNameValidator.validateChildAttributeName(key);
                    }
                    catch (ConsumerException ex) {
                        throw new UncheckedConsumerException(ex);
                    }
                    if (val == null) {
                        return this.remove(key);
                    }
                    if (!(val instanceof GenericType)) {
                        throw new UncheckedConsumerException(new ConsumerException("unsupported type: " + val.getClass()));
                    }
                    return super.put(key, val);
                }
            }

            public synchronized Object remove(Object key) {
                try {
                    this.this$0.checkMutable();
                }
                catch (ImmutableException ex) {
                    throw new UncheckedConsumerException(ex);
                }
                try {
                    ChildNameValidator.validateChildAttributeName(key);
                }
                catch (ConsumerException ex) {
                    throw new UncheckedConsumerException(ex);
                }
                return super.remove(key);
            }
        }
        this.childrenTypes = initialMap == null ? new ChildrenHashMap(this) : new ChildrenHashMap(this, initialMap);
    }

    public GenericType(String typeName) throws ArgumentException {
        TypeNameValidator.validateTypeName(typeName);
        this.typeName = typeName;
    }

    public synchronized boolean isEnum() {
        return this.enumValue;
    }

    public boolean isList() {
        return this.elementsType() != null;
    }

    public synchronized boolean isCompound() {
        return !this.childrenTypes().isEmpty();
    }

    public synchronized String typeName() {
        return this.typeName;
    }

    public synchronized String UCDType() {
        return this.ucd;
    }

    public synchronized String unit() {
        return this.unit;
    }

    public synchronized Data newData() throws ConsumerException {
        return this.newData(null);
    }

    public synchronized Data newData(Object initialValue) throws ArgumentException, ConsumerException {
        Data vd;
        if (initialValue instanceof String && (vd = this.isList() ? this.elementsType().valueDomain() : this.valueDomain()) != null) {
            GenericData idElem = (GenericData)vd.get((String)initialValue);
            if (idElem != null) {
                return idElem;
            }
            if (vd.isEnum() && vd.isList()) {
                this.getLogger().warn((Object)("--> value " + initialValue + " not in domain of " + this.valueDomain().elementsType().typeName()));
            }
        }
        if (this.neutral_data == null) {
            this.neutral_data = new GenericData(this);
        }
        GenericData newData = (GenericData)this.neutral_data.clone();
        newData.setReadonly(false);
        if (initialValue instanceof Data) {
            newData.set((Data)initialValue);
        } else if (initialValue != null) {
            newData.setValue(initialValue);
        }
        return newData;
    }

    public synchronized Map childrenTypes() {
        if (this.childrenTypes == null) {
            this.initChildrenTypes(null);
        }
        return this.childrenTypes;
    }

    public synchronized Type elementsType() {
        return this.elemsType;
    }

    public synchronized Data valueDomain() {
        return this.valueDomain;
    }

    public synchronized void setElemsType(GenericType type) throws ImmutableException {
        if (this.equals(type)) {
            ArgumentException aex = new ArgumentException("attempt to set an type's elements type to the same type as the list type");
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)("WARNING: " + aex.getMessage()), (Throwable)((Object)aex));
            }
        }
        this.checkMutable();
        this.elemsType = type;
    }

    public synchronized void setNeutralData(GenericData data) throws ArgumentException, ImmutableException {
        this.checkMutable();
        if (data.type() != this) {
            throw new ArgumentException("wrong data type: expected " + this.typeName() + " but got " + data.typeName());
        }
        this.neutral_data = data;
    }

    public synchronized void setUcd(String string) throws ImmutableException {
        this.checkMutable();
        this.ucd = string;
    }

    public synchronized void setUnit(String string) throws ImmutableException {
        this.checkMutable();
        this.unit = string;
    }

    public synchronized void setValueDomain(GenericData data) throws ImmutableException, ArgumentException {
        this.checkMutable();
        if (data != null && !(data instanceof Interval) && !data.isList()) {
            throw new ArgumentException("expected a value domain to be either a list or an interval or null but got: " + data.getClass());
        }
        this.valueDomain = data;
    }

    public synchronized String toString() {
        Map ct = this.childrenTypes();
        Type et = this.elementsType();
        Data vd = this.valueDomain();
        return "GenericType(typeName=" + this.typeName() + " " + "enum=" + this.isEnum() + " " + "list=" + this.isList() + " " + "compound=" + this.isCompound() + " " + "childrenTypes=" + (ct == null ? "null" : "" + ct.keySet()) + " " + "elemsType=" + (et == null ? "null" : et.typeName()) + " " + "ucd=" + this.UCDType() + " " + "unit=" + this.unit() + " " + "valueDomain=" + (vd == null ? "null" : vd.id()) + ")";
    }

    public final boolean equals(Object otherType) {
        if (otherType == null) {
            return false;
        }
        if (otherType == this) {
            return true;
        }
        if (otherType instanceof GenericType) {
            return this.equals((GenericType)otherType);
        }
        return super.equals(otherType);
    }

    public int objectHashCode() {
        return super.hashCode();
    }

    private final boolean equals(GenericType otherType) {
        return this.equals(otherType, null, null);
    }

    /*
     * Exception decompiling
     */
    boolean equals(GenericType otherType, Map thisStopList, Map otherStopList) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 23[MONITOR]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected boolean equalsNr(GenericType otherType) {
        GenericType x = otherType;
        return x == otherType;
    }

    public int hashCode() {
        return this.typeName().hashCode();
    }

    public final Object clone() {
        return this.clone(null);
    }

    synchronized Object clone(Map clonedList) {
        GenericType clone;
        Object cachedClone;
        if (clonedList == null) {
            clonedList = new HashMap<GenericType, GenericType>();
        }
        if ((cachedClone = clonedList.get(this)) != null) {
            return cachedClone;
        }
        try {
            clone = (GenericType)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            return null;
        }
        clonedList.put(this, clone);
        if (this.elemsType != null) {
            GenericType etc = (GenericType)clonedList.get(this.elemsType);
            if (etc == null) {
                etc = (GenericType)this.elemsType.clone(clonedList);
            }
            clone.elemsType = etc;
        }
        if (this.childrenTypes != null) {
            HashMap<String, GenericType> childrenTypes = new HashMap<String, GenericType>();
            Iterator it = this.childrenTypes.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                String cn = (String)entry.getKey();
                GenericType ct = (GenericType)entry.getValue();
                GenericType ctc = (GenericType)clonedList.get(ct);
                if (ctc == null) {
                    ctc = (GenericType)ct.clone(clonedList);
                }
                childrenTypes.put(cn, ctc);
            }
            clone.childrenTypes = null;
            clone.initChildrenTypes(childrenTypes);
        }
        if (this.valueDomain != null) {
            clone.valueDomain = (GenericData)this.valueDomain.clone(clonedList, true);
        }
        if (this.neutral_data != null) {
            clone.neutral_data = (GenericData)this.neutral_data.clone(clonedList, true);
        }
        return this.cloneNr(clone);
    }

    protected Object cloneNr(GenericType gtClone) {
        gtClone.immutable = false;
        return gtClone;
    }

    public synchronized void setEnum(boolean enumValue) throws ImmutableException {
        this.checkMutable();
        this.enumValue = enumValue;
    }

    public synchronized boolean distinct() {
        return this.distinct;
    }

    public synchronized void setDistinct(boolean distinct) throws ImmutableException {
        this.checkMutable();
        this.distinct = distinct;
    }

    public synchronized boolean isImmutable() {
        return this.immutable;
    }

    public synchronized void setImmutable(boolean immutable) throws ArgumentException {
        if (!immutable && this.immutable) {
            throw new ArgumentException("a type cannot be altered once made immutable.");
        }
        if (this.elementsType() != null) {
            try {
                this.setElemsType(this.replaceByImmutableType((GenericType)this.elementsType()));
            }
            catch (ImmutableException ex) {
                this.getLogger().warn((Object)"unexpected occurrence of buggy exception: ", (Throwable)((Object)ex));
            }
        }
        if (this.childrenTypes != null) {
            Map ct = this.childrenTypes();
            LinkedList ctkeys = new LinkedList(ct.keySet());
            Iterator ctit = ctkeys.iterator();
            while (ctit.hasNext()) {
                String childName = (String)ctit.next();
                try {
                    ct.put(childName, this.replaceByImmutableType((GenericType)ct.get(childName)));
                }
                catch (UncheckedConsumerException ex) {
                    try {
                        ex.unwrapImmEx();
                    }
                    catch (ImmutableException exx) {
                        this.getLogger().warn((Object)"unexpected occurrence of buggy exception: ", (Throwable)((Object)exx));
                    }
                }
            }
        }
        this.immutable = immutable;
    }

    private GenericType replaceByImmutableType(GenericType type) {
        if (type.isImmutable()) {
            return type;
        }
        type = (GenericType)type.clone();
        try {
            type.setImmutable(true);
        }
        catch (ArgumentException ex) {
            this.getLogger().warn((Object)"unexpected occurrence of buggy exception: ", (Throwable)((Object)ex));
        }
        return type;
    }

    protected void checkMutable() throws ImmutableException {
        if (this.isImmutable()) {
            throw new ImmutableException("This type was made immutable and does not allow anymore modifications.");
        }
    }

    void checkInValueDomain(Data data) throws ArgumentException {
        if (!this.isEnum()) {
            return;
        }
        if (!this.isList()) {
            return;
        }
        Data vd = this.valueDomain();
        if (vd == null) {
            return;
        }
        if (!(vd instanceof Interval) && !this.isList()) {
            return;
        }
        if (!vd.contains(data)) {
            ArgumentException aex = new ArgumentException("value not allowed for domain: " + data + " not in " + vd);
            this.getLogger().debug((Object)aex, (Throwable)((Object)aex));
            throw aex;
        }
    }
}

