/*
 * Decompiled with CFR 0.152.
 */
package org.egso.consumer.core;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.egso.common.logging.AbstractLogEnabled;
import org.egso.consumer.api.ArgumentException;
import org.egso.consumer.core.AbstractCatalogue;
import org.egso.consumer.core.GenericData;
import org.egso.consumer.core.GenericType;
import org.egso.consumer.core.Parameter;
import org.egso.consumer.core.Result;
import org.egso.consumer.types.egso.EGSOTypesFactory;

public class ParameterStore
extends AbstractLogEnabled {
    private static final ParameterStore instance = new ParameterStore();
    private Map params = Collections.synchronizedMap(new HashMap());
    private Map results = Collections.synchronizedMap(new HashMap());

    private ParameterStore() {
    }

    public static ParameterStore getInstance() {
        return instance;
    }

    public Parameter getParameter(String data_key) {
        return (Parameter)((Object)this.params.get(data_key));
    }

    public Result getResult(String data_key) {
        return (Result)((Object)this.results.get(data_key));
    }

    public Collection getAllParameters() {
        return this.params.values();
    }

    public Collection getAllResults() {
        return this.results.values();
    }

    public Collection getAllParametersAndResults() {
        LinkedList x = new LinkedList();
        x.addAll(this.getAllParameters());
        x.addAll(this.getAllResults());
        return x;
    }

    public Parameter resolveOrCreateParameter(String param_name, GenericType type) throws ArgumentException {
        Parameter p = (Parameter)((Object)this.params.get(param_name));
        if (p != null) {
            if (!p.getType().equals(type)) {
                throw new RuntimeException("unacceptable type '" + type + "' for parameter '" + param_name + "' because already assigned to '" + p.getType() + "'.");
            }
            return p;
        }
        p = new Parameter(param_name, type);
        this.registerParameter(p);
        return p;
    }

    public Parameter resolveOrCreateParameter(String param_name, GenericData initVal) throws ArgumentException {
        Parameter p = this.resolveOrCreateParameter(param_name, (GenericType)initVal.type());
        p.setInitValue(initVal);
        return p;
    }

    protected Parameter resolveOrCreateParameter(String param_name, String type_name) throws ArgumentException {
        return this.resolveOrCreateParameter(param_name, EGSOTypesFactory.getInstance().getType(type_name));
    }

    public Parameter resolveOrCreateParameter(String param_name, GenericType type, String cat_name) throws ArgumentException {
        Parameter p = this.resolveOrCreateParameter(param_name, type);
        p.addCatalogue(cat_name);
        return p;
    }

    public Parameter resolveOrCreateParameter(String param_name, GenericType type, AbstractCatalogue cat) throws ArgumentException {
        Parameter p = this.resolveOrCreateParameter(param_name, type);
        p.addCatalogue(cat);
        return p;
    }

    public Parameter resolveOrCreateParameter(String param_name, GenericData initVal, AbstractCatalogue cat) throws ArgumentException {
        Parameter p = this.resolveOrCreateParameter(param_name, (GenericType)initVal.type(), cat);
        p.setInitValue(initVal);
        return p;
    }

    public Parameter resolveOrCreateParameter(String param_name, String type_name, String cat_name) throws ArgumentException {
        GenericType type = EGSOTypesFactory.getInstance().getType(type_name);
        if (type == null) {
            throw new ArgumentException("Could not find type with id '" + type_name + "'");
        }
        Parameter p = this.resolveOrCreateParameter(param_name, type);
        p.addCatalogue(cat_name);
        return p;
    }

    public Result resolveOrCreateResult(String result_name, GenericType type) throws ArgumentException {
        Result p = (Result)((Object)this.results.get(result_name));
        if (p != null) {
            if (!p.getType().equals(type)) {
                throw new RuntimeException("unacceptable type '" + type + "' for result '" + result_name + "' because already assigned to '" + p.getType() + "'.");
            }
            return p;
        }
        p = new Result(result_name, type);
        this.registerResult(p);
        return p;
    }

    public Result resolveOrCreateResult(String result_name, String type_name) throws ArgumentException {
        return this.resolveOrCreateResult(result_name, EGSOTypesFactory.getInstance().getType(type_name));
    }

    public Result resolveOrCreateResult(String result_name, GenericType type, String cat_name) throws ArgumentException {
        Result p = this.resolveOrCreateResult(result_name, type);
        p.addCatalogue(cat_name);
        return p;
    }

    public Result resolveOrCreateResult(String result_name, GenericType type, AbstractCatalogue cat) throws ArgumentException {
        Result p = this.resolveOrCreateResult(result_name, type);
        p.addCatalogue(cat);
        return p;
    }

    public Result resolveOrCreateResult(String result_name, String type_name, String cat_name) throws ArgumentException {
        Result p = this.resolveOrCreateResult(result_name, EGSOTypesFactory.getInstance().getType(type_name));
        p.addCatalogue(cat_name);
        return p;
    }

    private void registerParameter(Parameter param) {
        if (this.params.put(param.getDataKey(), param) != null) {
            throw new RuntimeException("duplicate parameter name");
        }
    }

    private void registerResult(Result result) {
        if (this.results.put(result.getDataKey(), result) != null) {
            throw new RuntimeException("duplicate result name");
        }
    }

    public ParameterStore reset() {
        this.params = new HashMap();
        this.results = new HashMap();
        return this;
    }
}

