/*
 * Decompiled with CFR 0.152.
 */
package org.egso.consumer.core;

import java.util.Iterator;
import org.egso.common.logging.AbstractLogEnabled;
import org.egso.consumer.api.ConsumerException;
import org.egso.consumer.api.Data;
import org.egso.consumer.core.AbstractParameter;
import org.egso.consumer.core.GenericData;
import org.egso.consumer.core.GenericQuery;
import org.egso.consumer.core.Updator;

public class QueryData
extends AbstractLogEnabled {
    private final GenericQuery query;
    private final AbstractParameter param;
    private GenericData data = null;
    private long modStamp = 0L;

    public QueryData(GenericQuery query, AbstractParameter param) {
        this.query = query;
        this.param = param;
    }

    public synchronized GenericData getData() {
        return this.data;
    }

    public synchronized void setData(GenericData data) {
        this.makeUpToDate();
        this.data = data;
    }

    public synchronized void setValue(Object value) throws ConsumerException {
        GenericData newData = (GenericData)this.param.getType().newData(value);
        this.makeUpToDate();
        this.data = newData;
    }

    protected void makeUpToDate() {
        long newModStamp = this.query.incModCount();
        QueryData queryData = this;
        synchronized (queryData) {
            this.modStamp = newModStamp;
        }
    }

    public synchronized long getModStamp() {
        return this.modStamp;
    }

    public synchronized void makeDirty() {
        this.modStamp = 0L;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean dirty() {
        GenericQuery genericQuery = this.query;
        synchronized (genericQuery) {
            if (this.getData() == null) {
                return true;
            }
            Iterator it = this.param.getDependsOn().iterator();
            while (true) {
                if (!it.hasNext()) {
                    return false;
                }
                AbstractParameter p = (AbstractParameter)((Object)it.next());
                QueryData qd = this.query.getQueryData(p);
                if (qd == null || qd.getData() == null) continue;
                if (qd.getModStamp() > this.getModStamp()) return true;
                if (qd.dirty()) break;
            }
            return true;
        }
    }

    public boolean update() throws ConsumerException {
        GenericQuery genericQuery = this.query;
        synchronized (genericQuery) {
            Updator updator;
            block6: {
                block5: {
                    if (this.getModStamp() <= 0L || this.dirty()) break block5;
                    return false;
                }
                updator = this.param.getUpdator();
                if (updator != null) break block6;
                return false;
            }
            Data update = updator.update(this.query, this.param);
            this.setData((GenericData)update);
            this.makeUpToDate();
            return update != null;
        }
    }

    public synchronized String toString() {
        return "QueryData(param=" + (Object)((Object)this.param) + " query=" + this.query + " value=" + this.data + " modStamp=" + this.modStamp + ")";
    }

    public void unset() {
        this.setData(null);
    }

    public boolean isSet() {
        return this.getData() != null;
    }
}

