/*
 * Decompiled with CFR 0.152.
 */
package org.egso.consumer.eci;

import org.apache.commons.configuration.Configuration;
import org.egso.common.configuration.NamedConfigurationFactory;
import org.egso.common.logging.AbstractLogEnabled;
import org.egso.consumer.ConfigurationLiterals;
import org.egso.consumer.api.ConsumerException;
import org.egso.consumer.eci.ECIFacade;

public class ECIFactory
extends AbstractLogEnabled
implements ConfigurationLiterals {
    public static final String DEFAULT_ECI_IMPL = "org.egso.consumer.eci.ECIConnector";
    private static String implClass = null;

    public static synchronized String getImplClass() {
        return implClass;
    }

    public static synchronized void setImplClass(String implClass) {
        ECIFactory.implClass = implClass;
    }

    public ECIFacade create() throws ConsumerException {
        ECIFactory eCIFactory = this;
        synchronized (eCIFactory) {
            if (implClass == null) {
                Configuration config = NamedConfigurationFactory.getConfigurationByName((String)"org.egso.consumer");
                implClass = config.getString("consumer.eci.impl", DEFAULT_ECI_IMPL);
            }
        }
        try {
            return (ECIFacade)Class.forName(implClass).newInstance();
        }
        catch (Exception ex) {
            ConsumerException cex = new ConsumerException("Eci Impl not found: " + implClass);
            this.getLogger().fatal((Object)cex);
            throw cex;
        }
    }
}

