/*
 * Decompiled with CFR 0.152.
 */
package org.egso.consumer.eci.dummy;

import java.io.BufferedReader;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.configuration.Configuration;
import org.egso.common.configuration.NamedConfigurationFactory;
import org.egso.common.context.EGSOContext;
import org.egso.common.logging.AbstractLogEnabled;
import org.egso.consumer.ConfigurationLiterals;
import org.egso.consumer.Consumer;
import org.egso.consumer.api.ArgumentException;
import org.egso.consumer.api.ConsumerException;
import org.egso.consumer.eci.ECIFacade;
import org.egso.consumer.eci.dummy.Diff;

public class ECIDummy
extends AbstractLogEnabled
implements ECIFacade,
ConfigurationLiterals {
    private static final Pattern pattern;

    static {
        try {
            NamedConfigurationFactory.addNamedConfiguration((String)"org.egso.consumer", (String)"/org/egso/consumer/conf", (String)"consumer");
        }
        catch (Exception exception) {
            // empty catch block
        }
        pattern = Pattern.compile("\\s*<data.*type=\"([a-zA-Z]*)\".*>\\s*");
    }

    public void callBroker(ECIFacade.ECI_args_t args) throws ConsumerException {
        String datapath;
        String[] qFileName;
        if (this.getLogger().isInfoEnabled()) {
            this.getLogger().info((Object)"using ECIDummy instead of real ECI");
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)("got query:\n" + args.query));
        }
        if ((qFileName = new File(datapath = this.getDataPath()).list(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                dir.length();
                return name.endsWith(".querysource.xml");
            }
        })) != null) {
            int n = qFileName.length;
            double[] qCorrespondence = new double[n];
            int iMaxCorrespondence = 0;
            String queryType = null;
            BufferedReader qActual = new BufferedReader(new StringReader(args.query));
            ArrayList<String> queryActual = new ArrayList<String>();
            try {
                String line = qActual.readLine();
                while (line != null) {
                    Matcher matcher = pattern.matcher(line);
                    if (matcher.matches()) {
                        queryType = matcher.group(1);
                    }
                    queryActual.add(line.trim());
                    line = qActual.readLine();
                }
                qActual.close();
                Collections.sort(queryActual);
            }
            catch (IOException e) {
                throw new ConsumerException("IOException while reading the query", e);
            }
            if (queryType == null) {
                this.getLogger().warn((Object)"could not locate queryType in input query");
            }
            int i = 0;
            while (i < n) {
                try {
                    boolean boost = false;
                    boolean foundQueryType = false;
                    BufferedReader qRef = new BufferedReader(new InputStreamReader(new URL("file:" + datapath + "/" + qFileName[i]).openStream()));
                    ArrayList<String> queryRef = new ArrayList<String>();
                    try {
                        String line = qRef.readLine();
                        while (line != null) {
                            Matcher matcher = pattern.matcher(line);
                            if (matcher.matches()) {
                                foundQueryType = true;
                                if (queryType.equals(matcher.group(1))) {
                                    this.getLogger().info((Object)("boosting: " + qFileName[i]));
                                    boost = true;
                                }
                            }
                            queryRef.add(line.trim());
                            line = qRef.readLine();
                        }
                        Collections.sort(queryRef);
                    }
                    catch (IOException e) {
                        throw new ConsumerException("IOException while reading the query", e);
                    }
                    qRef.close();
                    if (!foundQueryType) {
                        this.getLogger().warn((Object)("could not find queryType for sample query " + qFileName[i]));
                    }
                    Diff diff = new Diff(queryActual.toArray(), queryRef.toArray());
                    Diff.change change2 = diff.diff(Diff.forwardScript);
                    int deleted = 0;
                    int inserted = 0;
                    while (change2 != null) {
                        deleted += change2.deleted;
                        inserted += change2.inserted;
                        change2 = change2.link;
                    }
                    qCorrespondence[i] = 1.0 / ((0.0 + (double)deleted + (double)inserted) / (0.0 + (double)queryActual.size() + (double)queryRef.size())) + (double)boost;
                    if (qCorrespondence[i] > qCorrespondence[iMaxCorrespondence]) {
                        iMaxCorrespondence = i;
                    }
                }
                catch (Exception ex) {
                    ConsumerException cex = new ConsumerException(ex);
                    this.getLogger().warn((Object)cex);
                    throw cex;
                }
                ++i;
            }
            try {
                int c;
                String url = "file:" + datapath + "/" + qFileName[iMaxCorrespondence].replaceAll(".querysource.xml", ".votable.xml");
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug((Object)("ECIDummy is loading result file: " + url));
                }
                InputStreamReader votablereader = new InputStreamReader(new URL(url).openStream());
                StringBuffer buf = new StringBuffer();
                while ((c = ((Reader)votablereader).read()) >= 0) {
                    buf.append((char)c);
                }
                ((Reader)votablereader).close();
                args.answer = buf.toString();
                EGSOContext context = Consumer.getContextFactory().createContext(1);
                context.addRoute("load_file", url);
                args.context = context;
                return;
            }
            catch (Exception ex) {
                ConsumerException cex = new ConsumerException(ex);
                this.getLogger().warn((Object)cex);
                throw cex;
            }
        }
        throw new ArgumentException("query not supported by ECIDummy.");
    }

    public String callCosec(String startDate, String endDate, int plotType) {
        if (this.getLogger().isInfoEnabled()) {
            this.getLogger().info((Object)"using ECIDummy instead of real ECI");
        }
        startDate = startDate.replaceAll(":|.|-| |[|]", "");
        endDate = endDate.replaceAll(":|.|-| |[|]", "");
        try {
            startDate = URLEncoder.encode(startDate, "US-ASCII");
        }
        catch (UnsupportedEncodingException ex) {
            startDate = "-";
        }
        try {
            endDate = URLEncoder.encode(endDate, "US-ASCII");
        }
        catch (UnsupportedEncodingException ex) {
            endDate = "-";
        }
        switch (plotType) {
            case 1: {
                return "http://tashmetum.ifi.fh-aargau.ch/sample.png?proton-" + startDate + "-" + endDate;
            }
            case 2: {
                return "http://tashmetum.ifi.fh-aargau.ch/sample.png?xray-" + startDate + "-" + endDate;
            }
        }
        return "http://tashmetum.ifi.fh-aargau.ch/sample.png" + startDate + "-" + endDate;
    }

    private String getDataPath() {
        String dp;
        String settingName = "consumer.eci.dummy.datapath";
        String defaultValue = "data";
        Configuration config = NamedConfigurationFactory.getConfigurationByName((String)"org.egso.consumer");
        String theFile = config.getString("consumer.eci.dummy.datapath");
        if (theFile == null || "".equals(theFile)) {
            this.getLogger().warn((Object)"could not find file for 'consumer.eci.dummy.datapath'.");
            theFile = "/" + this.getClass().getPackage().getName().replace('.', '/') + "/" + "data";
            if (this.getLogger().isInfoEnabled()) {
                this.getLogger().info((Object)("no configuration found for 'consumer.eci.dummy.datapath' continuing with default value: " + theFile));
            }
        }
        URL theURL = null;
        if (theFile.indexOf(58) > 0) {
            try {
                theURL = new URL(theFile);
                theURL.openConnection().getInputStream().close();
            }
            catch (MalformedURLException malformedURLException) {
            }
            catch (IOException ex) {
                theURL = null;
            }
        }
        if (theURL == null) {
            theURL = this.getClass().getResource(theFile);
        }
        if (theURL == null) {
            try {
                theURL = new URL("file:" + theFile);
            }
            catch (MalformedURLException ex) {
                // empty catch block
            }
        }
        if ((dp = theURL.toExternalForm()).startsWith("file:")) {
            dp = dp.substring(5);
        }
        if (this.getLogger().isInfoEnabled()) {
            this.getLogger().info((Object)("loading the 'consumer.eci.dummy.datapath' contents from " + theURL));
        }
        return dp;
    }
}

