/*
 * Decompiled with CFR 0.152.
 */
package org.egso.consumer.ftp;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.Socket;
import org.egso.consumer.ftp.FTPException;
import org.egso.consumer.ftp.FTPSocket;

public class FTPConnection {
    private FTPSocket ftpSocket = null;
    private Socket data = null;
    private String transfertType = null;

    public FTPConnection(String remoteHost) throws IOException, FTPException {
        this.ftpSocket = new FTPSocket(remoteHost);
    }

    public FTPConnection(String remoteHost, int port) throws IOException, FTPException {
        this.ftpSocket = new FTPSocket(remoteHost, port);
    }

    public FTPConnection(InetAddress remoteAddr) throws IOException, FTPException {
        this.ftpSocket = new FTPSocket(remoteAddr);
    }

    public FTPConnection(InetAddress remoteAddr, int port) throws IOException, FTPException {
        this.ftpSocket = new FTPSocket(remoteAddr, port);
    }

    public void setType(String type) throws IOException, FTPException {
        String typeStr = "A";
        if (type.equals("I")) {
            typeStr = "I";
        }
        this.ftpSocket.validateResponse(this.ftpSocket.sendCommand("TYPE " + typeStr), "200");
        this.transfertType = type;
    }

    public void setVerbose(boolean verb) {
        this.ftpSocket.setVerbose(verb);
    }

    public String getType() {
        return this.transfertType;
    }

    public String getRemoteHostName() {
        return this.ftpSocket.getRemoteHostName();
    }

    public void get(String localDirectory, String remoteFile) throws IOException, FTPException {
        int count;
        System.out.print("Getting " + remoteFile + " file...");
        this.data = this.ftpSocket.createDataSocket();
        DataInputStream in = new DataInputStream(this.data.getInputStream());
        BufferedInputStream bIn = new BufferedInputStream(in);
        String response = this.ftpSocket.sendCommand("RETR " + remoteFile);
        String[] validCodes = new String[]{"125", "150"};
        this.ftpSocket.validateResponse(response, validCodes);
        int taille = 4096;
        byte[] chunk = new byte[taille];
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(localDirectory, false));
        while ((count = bIn.read(chunk, 0, taille)) >= 0) {
            out.write(chunk, 0, count);
        }
        out.close();
        try {
            bIn.close();
            this.data.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        validCodes = new String[]{"226", "250"};
        response = this.ftpSocket.readResponse();
        this.ftpSocket.validateResponse(response, validCodes);
        System.out.println(" done");
    }

    public InputStream get(String remoteFile) throws IOException, FTPException {
        int slashindex = remoteFile.lastIndexOf(47);
        if (slashindex >= 0) {
            String pathPortion = remoteFile.substring(0, slashindex);
            String fileNamePortion = remoteFile.substring(slashindex + 1);
            this.chdir(pathPortion);
            return this.get(fileNamePortion);
        }
        this.data = this.ftpSocket.createDataSocket();
        DataInputStream in = new DataInputStream(this.data.getInputStream());
        BufferedInputStream bIn = new BufferedInputStream(in){

            public void close() throws IOException {
                super.close();
                String response = FTPConnection.this.ftpSocket.readResponse();
                FTPConnection.this.ftpSocket.validateResponse(response, new String[]{"226"});
            }
        };
        String response = this.ftpSocket.sendCommand("RETR " + remoteFile);
        this.ftpSocket.validateResponse(response, new String[]{"125", "150"});
        return bIn;
    }

    public void login(String user, String password) throws IOException, FTPException {
        String response = this.ftpSocket.sendCommand("USER " + user);
        this.ftpSocket.validateResponse(response, "331");
        response = this.ftpSocket.sendCommand("PASS " + password);
        this.ftpSocket.validateResponse(response, "230");
        this.setType("I");
    }

    public void user(String user) throws IOException, FTPException {
        String response = this.ftpSocket.sendCommand("USER " + user);
        String[] validCodes = new String[]{"230", "331"};
        this.ftpSocket.validateResponse(response, validCodes);
    }

    public void password(String password) throws IOException, FTPException {
        String response = this.ftpSocket.sendCommand("PASS " + password);
        String[] validCodes = new String[]{"230", "202"};
        this.ftpSocket.validateResponse(response, validCodes);
        this.setType("I");
    }

    public void quote(String command, String[] validCodes) throws IOException, FTPException {
        String response = this.ftpSocket.sendCommand(command);
        if (validCodes != null && validCodes.length > 0) {
            this.ftpSocket.validateResponse(response, validCodes);
        }
    }

    public String list(String mask) throws IOException, FTPException {
        return this.list(mask, false);
    }

    public String list(String mask, boolean details) throws IOException, FTPException {
        int count;
        boolean isBinary = false;
        if (this.transfertType.equals("I")) {
            isBinary = true;
            this.setType("A");
        }
        this.data = this.ftpSocket.createDataSocket();
        InputStreamReader in = new InputStreamReader(this.data.getInputStream());
        BufferedReader bIn = new BufferedReader(in);
        String command = details ? "LIST " : "NLST ";
        String response = this.ftpSocket.sendCommand(String.valueOf(command) + mask);
        String[] validCodes = new String[]{"125", "150"};
        this.ftpSocket.validateResponse(response, validCodes);
        int taille = 4096;
        char[] chunk = new char[taille];
        char[] resultBuf = new char[taille];
        char[] temp = null;
        int bufsize = 0;
        while ((count = bIn.read(chunk, 0, taille)) >= 0) {
            temp = new char[bufsize + count];
            System.arraycopy(resultBuf, 0, temp, 0, bufsize);
            System.arraycopy(chunk, 0, temp, bufsize, count);
            resultBuf = temp;
            bufsize += count;
        }
        try {
            bIn.close();
            this.data.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        validCodes = new String[]{"226", "250"};
        response = this.ftpSocket.readResponse();
        this.ftpSocket.validateResponse(response, validCodes);
        if (isBinary) {
            this.setType("I");
        }
        String result = null;
        if (resultBuf.length > 0) {
            result = new String(resultBuf);
        }
        return result;
    }

    public void chdir(String dir) throws IOException, FTPException {
        String response = this.ftpSocket.sendCommand("CWD " + dir);
        this.ftpSocket.validateResponse(response, "250");
    }

    public String pwd() throws IOException, FTPException {
        String response = this.ftpSocket.sendCommand("PWD");
        this.ftpSocket.validateResponse(response, "257");
        return response;
    }

    public void quit() throws IOException, FTPException {
        String response = this.ftpSocket.sendCommand("QUIT\r\n");
        this.ftpSocket.validateResponse(response, "221");
        this.ftpSocket.logout();
        this.ftpSocket = null;
    }
}

