/*
 * Decompiled with CFR 0.152.
 */
package org.egso.consumer.plot;

import java.io.Serializable;
import java.net.URL;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;

class URLCache {
    private static final String URL_CACHE_NAME = "plotURLCache";
    private Cache urlCache = null;
    private static URLCache instance = null;

    public static URLCache getInstance() {
        if (instance == null) {
            instance = new URLCache();
        }
        return instance;
    }

    private URLCache() {
        if (this.urlCache == null) {
            try {
                CacheManager cacheManager = CacheManager.create();
                this.urlCache = cacheManager.getCache(URL_CACHE_NAME);
            }
            catch (CacheException e) {
                throw new RuntimeException("Cannot create url cache", e);
            }
        }
    }

    public synchronized void putURL(String key, URL url) {
        this.urlCache.put(new Element((Serializable)((Object)key), (Serializable)url));
    }

    public URL getURL(String key) {
        try {
            Element el = this.urlCache.get((Serializable)((Object)key));
            if (el != null) {
                return (URL)el.getValue();
            }
            return null;
        }
        catch (CacheException e) {
            throw new RuntimeException(e);
        }
    }
}

