/*
 * Decompiled with CFR 0.152.
 */
package org.egso.consumer.remotequery;

import java.io.StringWriter;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.egso.common.logging.AbstractLogEnabled;
import org.egso.consumer.QueryLiterals;
import org.egso.consumer.api.ConsumerException;
import org.egso.consumer.api.Data;
import org.egso.consumer.api.Interval;
import org.egso.consumer.api.ScalarData;
import org.egso.consumer.core.AbstractCatalogue;
import org.egso.consumer.core.AbstractParameter;
import org.egso.consumer.core.GenericQuery;
import org.egso.consumer.core.UncheckedConsumerException;
import org.egso.consumer.core.Updator;
import org.egso.consumer.remotequery.FieldSelectorType;
import org.egso.consumer.types.IntervalData;
import org.egso.consumer.types.StringData;
import org.egso.consumer.types.votable.VOTableData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class QuerySourceUpdator
extends AbstractLogEnabled
implements Updator,
QueryLiterals {
    static DocumentBuilder docBuilder;
    static ConsumerException exception;
    static TransformerFactory tFactory;
    static Transformer transformer;

    static {
        exception = null;
        try {
            docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (Exception ex) {
            exception = new ConsumerException(ex);
        }
        tFactory = TransformerFactory.newInstance();
        try {
            transformer = tFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        }
        catch (TransformerConfigurationException ex) {
            exception = new ConsumerException(ex);
        }
    }

    public Data update(GenericQuery q, AbstractParameter param) throws ConsumerException {
        if (exception != null) {
            throw exception;
        }
        Document queryDoc = docBuilder.newDocument();
        this.xmlQuery(queryDoc, q, param);
        StringWriter out = new StringWriter();
        DOMSource source = new DOMSource(queryDoc);
        StreamResult result = new StreamResult(out);
        try {
            transformer.transform(source, result);
        }
        catch (TransformerException ex) {
            throw new ConsumerException(ex);
        }
        return new StringData(out.toString());
    }

    protected void xmlQuery(Document queryDoc, GenericQuery q, AbstractParameter param) throws ConsumerException {
        Element queryRoot = queryDoc.createElement("query");
        queryDoc.appendChild(queryRoot);
        queryRoot.setAttribute("version", "2.0");
        this.xmlFieldSelector(queryDoc, q, param);
        Set cats = Collections.unmodifiableSet(param.getCatalogues());
        if (cats.size() != 1) {
            throw new ConsumerException("result '" + param.getDataKey() + "' must be assigned to exactly one catalogue");
        }
        AbstractCatalogue cat = (AbstractCatalogue)((Object)cats.toArray()[0]);
        Element dataRoot = queryDoc.createElement("data");
        dataRoot.setAttribute("type", cat.getName());
        dataRoot.setAttribute("default-relation", "AND");
        dataRoot.setAttribute("relation", "AND");
        queryRoot.appendChild(dataRoot);
        Set dep = Collections.unmodifiableSet(param.getDependsOn());
        Iterator dit = dep.iterator();
        while (dit.hasNext()) {
            AbstractParameter p = (AbstractParameter)((Object)dit.next());
            if (p.getType() instanceof FieldSelectorType) continue;
            String paramKey = p.getDataKey();
            Data pData = q.get(paramKey);
            if (!q.isSet(paramKey)) continue;
            this.assembleParam(dataRoot, pData, paramKey);
        }
    }

    protected void xmlFieldSelector(Document queryDoc, GenericQuery q, AbstractParameter param) throws ConsumerException {
        Set dep = Collections.unmodifiableSet(param.getDependsOn());
        AbstractParameter fsp = null;
        Iterator dit = dep.iterator();
        while (dit.hasNext()) {
            AbstractParameter p = (AbstractParameter)((Object)dit.next());
            if (!(p.getType() instanceof FieldSelectorType)) continue;
            if (fsp != null) {
                throw new ConsumerException("more than one field selector found for parameter '" + param.getDataKey() + "'");
            }
            fsp = p;
        }
        Element select = null;
        if (fsp != null) {
            Data fs = q.get(fsp.getDataKey());
            if (fs == null) {
                fs = fsp.getType().newData();
            }
            select = queryDoc.createElement("select");
            queryDoc.getDocumentElement().appendChild(select);
            Iterator fit = fs.elements().iterator();
            while (fit.hasNext()) {
                Data field = (Data)fit.next();
                Element fieldNode = queryDoc.createElement("field");
                fieldNode.setAttribute("name", field.id());
                select.appendChild(fieldNode);
            }
        }
    }

    protected void assembleParam(Node parent, Data param, String param_name) {
        if (param == null) {
            return;
        }
        if (param.type() instanceof VOTableData.VOTableType) {
            this.assembleGroups(parent, param);
        } else {
            Element paramTag = parent.getOwnerDocument().createElement("param");
            paramTag.setAttribute("name", param_name);
            if (param.isList()) {
                paramTag.setAttribute("relation", "OR");
            }
            parent.appendChild(paramTag);
            this.assembleData(paramTag, param);
        }
    }

    protected void assembleData(Node parent, Data param) {
        if (param instanceof Interval) {
            this.assembleInterval(parent, (IntervalData)param);
        } else if (param.isList()) {
            this.assembleList(parent, param);
        } else if (param.id() != null) {
            this.assembleValue(parent, param);
        } else {
            throw new UncheckedConsumerException(new ConsumerException("Unexpected DataType: '" + param + "'"));
        }
    }

    protected void assembleGroups(Node parent, Data groups) {
        Iterator it = groups.elements().iterator();
        while (it.hasNext()) {
            Data element = (Data)it.next();
            Element groupTag = parent.getOwnerDocument().createElement("group");
            parent.appendChild(groupTag);
            Iterator fit = ((VOTableData.VOTableType)groups.type()).getJoinSet().iterator();
            while (fit.hasNext()) {
                String pname = (String)fit.next();
                Data param = (Data)element.children().get(pname);
                if (param == null) continue;
                if (param.isCompound() && !(param.type() instanceof VOTableData.VOTableType) && !param.isList() && param.id() == null) {
                    Iterator cit = param.children().entrySet().iterator();
                    while (cit.hasNext()) {
                        Map.Entry entry = cit.next();
                        this.assembleParam(groupTag, (Data)entry.getValue(), (String)entry.getKey());
                    }
                    continue;
                }
                this.assembleParam(groupTag, param, pname);
            }
        }
    }

    protected void assembleInterval(Node parent, IntervalData interval) {
        ScalarData min = interval.getMin();
        ScalarData max = interval.getMax();
        if (min != null || max != null) {
            Element startTag;
            Element intervalTag = parent.getOwnerDocument().createElement("interval");
            parent.appendChild(intervalTag);
            if (min != null) {
                startTag = parent.getOwnerDocument().createElement("start");
                intervalTag.appendChild(startTag);
                startTag.appendChild(parent.getOwnerDocument().createTextNode(min.id()));
            }
            if (max != null) {
                startTag = parent.getOwnerDocument().createElement("end");
                intervalTag.appendChild(startTag);
                startTag.appendChild(parent.getOwnerDocument().createTextNode(max.id()));
            }
        }
    }

    protected void assembleList(Node parent, Data list) {
        Iterator it = list.elements().iterator();
        while (it.hasNext()) {
            Data element = (Data)it.next();
            this.assembleData(parent, element);
        }
    }

    protected void assembleValue(Node parent, Data value) {
        Element valueTag = parent.getOwnerDocument().createElement("value");
        parent.appendChild(valueTag);
        valueTag.appendChild(parent.getOwnerDocument().createTextNode(value.id()));
    }
}

