/*
 * Decompiled with CFR 0.152.
 */
package org.egso.consumer.ssr;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.egso.consumer.ConfigurationLiterals;
import org.egso.consumer.EGSOLiterals;
import org.egso.consumer.api.ArgumentException;
import org.egso.consumer.api.ConsumerException;
import org.egso.consumer.api.Data;
import org.egso.consumer.config.CatalogConfig;
import org.egso.consumer.core.AbstractParameter;
import org.egso.consumer.core.GenericQuery;
import org.egso.consumer.core.GenericType;
import org.egso.consumer.core.Parameter;
import org.egso.consumer.core.ParameterStore;
import org.egso.consumer.core.Result;
import org.egso.consumer.core.Updator;
import org.egso.consumer.ssr.SSRLoader;
import org.egso.consumer.ssr.SSRQuerySourceUpdator;

public class SSR
extends CatalogConfig
implements Updator,
EGSOLiterals,
ConfigurationLiterals {
    private ParameterStore ps = ParameterStore.getInstance();
    private Connection connection = null;

    public SSR() {
        super("ssr");
    }

    public List getTypes() throws ConsumerException {
        ArrayList<GenericType> types = new ArrayList<GenericType>();
        SSRLoader ssrLoader = SSRLoader.getInstance();
        Iterator iter = ssrLoader.getSSRTypes().values().iterator();
        while (iter.hasNext()) {
            GenericType type = (GenericType)iter.next();
            types.add(type);
        }
        this.connection = ssrLoader.getConnection();
        return types;
    }

    public void initParameters() throws ConsumerException {
        String dataKey;
        HashMap<String, String> ssrParams = new HashMap<String, String>();
        ssrParams.put("time_start", "type_date");
        ssrParams.put("time_start", "type_date");
        ssrParams.put("instrument", "type_instrument_list");
        ssrParams.put("observatory", "type_observatory_list");
        ssrParams.put("measurement_type", "type_measurement_type_list");
        ssrParams.put("observing_domain_cat", "type_observing_domain_cat_list");
        ssrParams.put("observing_domain_type", "type_observing_domain_type_list");
        ssrParams.put("observable_entity_cat", "type_observable_entity_cat_list");
        ssrParams.put("observable_entity_type", "type_observable_entity_type_list");
        ssrParams.put("observable_entity_type_insitu", "type_observable_entity_type_list");
        ssrParams.put("observable_entity_type_remote", "type_observable_entity_type_list");
        ssrParams.put("observing_type", "type_observing_type_list");
        ssrParams.put("observing_type_insitu", "type_observing_type_insitu_list");
        ssrParams.put("observing_type_remote", "type_observing_type_remote_list");
        ssrParams.put("observatory_location", "type_observatory_location_list");
        ArrayList<Parameter> params = new ArrayList<Parameter>();
        ArrayList<Result> results = new ArrayList<Result>();
        params.add(this.ps.resolveOrCreateParameter("date", CatalogConfig.typesFactory.getType("type_date_interval")));
        Iterator iter = ssrParams.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            dataKey = (String)entry.getKey();
            String typeName = (String)entry.getValue();
            params.add(this.ps.resolveOrCreateParameter(dataKey, typeName, "ssr"));
            results.add(this.ps.resolveOrCreateResult(dataKey, typeName, "ssr"));
        }
        iter = results.iterator();
        while (iter.hasNext()) {
            Result result = (Result)((Object)iter.next());
            dataKey = result.getDataKey();
            Result querySource = this.ps.resolveOrCreateResult(String.valueOf(dataKey) + "_querysource", "type_query_source", "ssr");
            querySource.setUpdator(new SSRQuerySourceUpdator(dataKey));
            result.addDependsOn(querySource);
            Iterator iterator = params.iterator();
            while (iterator.hasNext()) {
                Parameter param = (Parameter)((Object)iterator.next());
                querySource.addDependsOn(param);
            }
            result.setUpdator(this);
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Data update(GenericQuery query, AbstractParameter param) throws ConsumerException {
        block20: {
            dataKey = param.getDataKey();
            if (param == null) {
                throw new IllegalArgumentException("Cannot find parameter '" + dataKey + "' in data store");
            }
            type = param.getType();
            result = type.newData();
            valueDomain = type.elementsType().valueDomain();
            queryString = null;
            stmt = null;
            rs = null;
            try {
                try {
                    stmt = this.connection.createStatement();
                    queryString = (String)query.getResult(String.valueOf(param.getDataKey()) + "_querysource").getValue();
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug((Object)("Query for ssr: " + queryString));
                    }
                    rs = stmt.executeQuery(queryString);
                    block11: while (true) {
                        if (!rs.next()) {
                            var16_16 = result;
                            var14_17 = null;
                            if (stmt == null) break block20;
                            break;
                        }
                        value = rs.getString(1);
                        if (value == null || value.equals("")) continue;
                        values = value.split(",");
                        i = 0;
                        while (true) {
                            if (i < values.length) ** break;
                            continue block11;
                            data = valueDomain.get(values[i]);
                            if (data == null) {
                                if (!dataKey.endsWith("insitu") && !dataKey.endsWith("remote")) {
                                    this.getLogger().warn((Object)("Illegal value '" + values[i] + "' for type '" + type.typeName() + "'. Result for '" + dataKey + "' is incomplete"));
                                }
                            } else {
                                result.add(data);
                            }
                            ++i;
                        }
                        break;
                    }
                }
                catch (ArgumentException ex) {
                    this.getLogger().error((Object)"error in SSR: subsequent results may be wrong!", (Throwable)ex);
                    throw ex;
                }
                catch (SQLException e) {
                    this.getLogger().error((Object)("Internal SQLException in SSR: " + e.getMessage()), (Throwable)e);
                    throw new ConsumerException("Internal SQLException in SSR: " + e.getMessage(), e);
                }
            }
            catch (Throwable var15_23) {
                var14_18 = null;
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (SQLException e1) {
                        throw new RuntimeException(e1);
                    }
                }
                if (rs == null) throw var15_23;
                try {
                    rs.close();
                    throw var15_23;
                }
                catch (SQLException e2) {
                    throw new RuntimeException(e2);
                }
            }
            try {}
            catch (SQLException e1) {
                throw new RuntimeException(e1);
            }
            stmt.close();
        }
        if (rs == null) return var16_16;
        try {}
        catch (SQLException e2) {
            throw new RuntimeException(e2);
        }
        rs.close();
        return var16_16;
    }
}

