/*
 * Decompiled with CFR 0.152.
 */
package org.egso.consumer.ssr;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.configuration.Configuration;
import org.egso.common.configuration.NamedConfigurationFactory;
import org.egso.common.logging.AbstractLogEnabled;
import org.egso.common.votable.rdbloader.VOTable2RDB;
import org.egso.consumer.EGSOLiterals;
import org.egso.consumer.api.ArgumentException;
import org.egso.consumer.api.ConsumerException;
import org.egso.consumer.api.ScalarType;
import org.egso.consumer.core.GenericData;
import org.egso.consumer.core.GenericType;
import org.egso.consumer.ssr.SSRHandler;
import org.egso.consumer.types.DateData;
import org.egso.consumer.types.IntervalData;

public class SSRLoader
extends AbstractLogEnabled
implements EGSOLiterals {
    private Connection connection = null;
    private String tableName;
    Map ssrTypes = new HashMap();
    private static SSRLoader ssrLoader = new SSRLoader();

    public static SSRLoader getInstance() {
        return ssrLoader;
    }

    private SSRLoader() {
        try {
            this.initSSRRDB();
            this.initSSRTypes();
        }
        catch (ConsumerException e) {
            throw new RuntimeException("Internal Error: Unable to iniialize SSR: " + e.getMessage(), (Throwable)((Object)e));
        }
    }

    public Connection getConnection() {
        return this.connection;
    }

    public String getTableName() {
        return this.tableName;
    }

    public Map getSSRTypes() {
        return this.ssrTypes;
    }

    private void initSSRRDB() throws ConsumerException {
        try {
            Class.forName("org.hsqldb.jdbcDriver");
            this.connection = DriverManager.getConnection("jdbc:hsqldb:mem:votableimport", "sa", "");
            InputStream ssrIn = this.loadFileRelativeToConfiguration("consumer.ssr.resource", "data/ssr.xml");
            VOTable2RDB votable2RDB = new VOTable2RDB();
            votable2RDB.doImport(ssrIn, this.connection);
            List tableNames = votable2RDB.getTableNames();
            if (tableNames.size() != 1) {
                throw new ConsumerException("Internal Error in SSR2RDMLoader: Illegal number of tables in imported ssr: " + tableNames.size());
            }
            this.tableName = (String)tableNames.get(0);
        }
        catch (Exception e) {
            throw new ConsumerException("Internal Error: " + e.getClass().getName() + " loading the SSR to an RDB: " + e.getMessage(), e);
        }
    }

    private void initSSRTypes() throws ConsumerException {
        GenericType type;
        try {
            InputStream ssrIn = this.loadFileRelativeToConfiguration("consumer.ssr.resource", "data/ssr.xml");
            SSRHandler worker = new SSRHandler();
            SSRHandler.parse(ssrIn, worker);
            this.ssrTypes = worker.getSSRTypes();
        }
        catch (IOException ex) {
            throw new ConsumerException("SSR::initialize: IOException while parsing: " + ex.getMessage(), ex);
        }
        HashMap<String, GenericType> addedTypes = new HashMap<String, GenericType>();
        Iterator tit = this.ssrTypes.values().iterator();
        while (tit.hasNext()) {
            type = (GenericType)tit.next();
            String data_key = type.typeName();
            if (type instanceof ScalarType && !(type instanceof DateData.DateType)) {
                try {
                    type = new IntervalData.IntervalType(type);
                    addedTypes.put(type.typeName(), type);
                }
                catch (ArgumentException ex) {
                    this.getLogger().error((Object)"this should not happen here.", (Throwable)((Object)ex));
                }
                if (!this.getLogger().isDebugEnabled()) continue;
                this.getLogger().debug((Object)("add ssr field '" + type.typeName() + "' (which is of scalar type) as query parameter '" + data_key + "' (as an interval type)."));
                continue;
            }
            if (type.isEnum()) {
                GenericType setType = new GenericType(String.valueOf(type.typeName()) + "_list");
                setType.setElemsType(type);
                type = setType;
                addedTypes.put(type.typeName(), type);
                if (!this.getLogger().isDebugEnabled()) continue;
                this.getLogger().debug((Object)("add ssr field '" + type.typeName() + "' (which is of discrete/enum type) as query parameter '" + data_key + "' (as a list-values type)."));
                continue;
            }
            if (!type.isList() && type.valueDomain() == null) {
                GenericType listType = new GenericType(String.valueOf(type.typeName()) + "_list");
                listType.setElemsType(type);
                type = listType;
                addedTypes.put(type.typeName(), type);
                if (!this.getLogger().isDebugEnabled()) continue;
                this.getLogger().debug((Object)("add ssr field '" + type.typeName() + "' as query parameter '" + data_key + "' (which is of" + "type list-... any value)."));
                continue;
            }
            if (!this.getLogger().isDebugEnabled()) continue;
            this.getLogger().debug((Object)("add ssr field '" + type.typeName() + "' as query parameter '" + data_key + "' (as far as " + "known here of type list-... or interval)."));
        }
        this.ssrTypes.putAll(addedTypes);
        type = (GenericType)this.ssrTypes.get("observing_type");
        if (type == null) {
            throw new ArgumentException("Internal Error: could not find type observing_type during the initialisation of the SSR");
        }
        String[] mts = new String[]{"remote", "insitu"};
        int i = 0;
        while (i < mts.length) {
            String mt = mts[i];
            GenericType elementsType = (GenericType)type.elementsType();
            GenericType otListTypeMT = new GenericType("type_observing_type_" + mt + "_list");
            GenericType otListTypeVD = new GenericType("_VD_observing_type_" + mt + "_list");
            GenericType otTypeMT = new GenericType("observing_type_" + mt);
            otListTypeMT.setElemsType(otTypeMT);
            otListTypeVD.setElemsType(otTypeMT);
            otTypeMT.setEnum(true);
            GenericData valueDomain = (GenericData)otListTypeVD.newData();
            Iterator iter = this.getObservingTypeByMt(mt).iterator();
            while (iter.hasNext()) {
                String ot = (String)iter.next();
                GenericData domainValue = (GenericData)elementsType.valueDomain().get(ot);
                GenericData newDomainValue = new GenericData(otTypeMT, domainValue.id());
                valueDomain.add(newDomainValue);
            }
            otTypeMT.setValueDomain(valueDomain);
            if (this.ssrTypes.put(otTypeMT.typeName(), otTypeMT) != null) {
                throw new ArgumentException("Internal Error: type " + otTypeMT.typeName() + " does already exist.");
            }
            if (this.ssrTypes.put(otListTypeMT.typeName(), otListTypeMT) != null) {
                throw new ArgumentException("Internal Error: type " + otListTypeMT.typeName() + " does already exist.");
            }
            ++i;
        }
    }

    private InputStream loadFileRelativeToConfiguration(String settingName, String defaultValue) throws IOException, ConsumerException {
        Configuration config = NamedConfigurationFactory.getConfigurationByName((String)"org.egso.consumer");
        String theFile = config.getString(settingName);
        if (theFile == null || "".equals(theFile)) {
            if (defaultValue == null) {
                this.getLogger().warn((Object)("could not find file for '" + settingName + "' and " + "no default value was specified."));
                return null;
            }
            theFile = defaultValue.charAt(0) == '/' ? defaultValue : "/" + this.getClass().getPackage().getName().replace('.', '/') + "/" + defaultValue;
            if (this.getLogger().isInfoEnabled()) {
                this.getLogger().info((Object)("no configuration found for '" + settingName + "' " + "continuing with default value..."));
            }
        }
        URL theURL = null;
        if (theFile.indexOf(58) > 0) {
            try {
                theURL = new URL(theFile);
                theURL.openConnection().getInputStream().close();
            }
            catch (MalformedURLException malformedURLException) {
            }
            catch (IOException ex) {
                theURL = null;
            }
        }
        if (theURL == null) {
            theURL = this.getClass().getResource(theFile);
        }
        if (theURL == null) {
            throw new ConsumerException("SSR::initialize(): '" + settingName + "' file was not found " + "(tried to load " + theFile + ")");
        }
        if (this.getLogger().isInfoEnabled()) {
            this.getLogger().info((Object)("loading the '" + settingName + "' contents " + "from " + theURL));
        }
        return theURL.openStream();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Set getObservingTypeByMt(String mt) throws ConsumerException {
        HashSet<String> ret = new HashSet<String>();
        try {
            Statement stmt = null;
            ResultSet rs = null;
            StringBuffer queryString = null;
            try {
                stmt = this.connection.createStatement();
                queryString = new StringBuffer().append("SELECT DISTINCT ").append("observing_type").append(" FROM ").append(this.tableName).append(" WHERE ").append("measurement_type").append(" = '").append(mt).append("';");
                rs = stmt.executeQuery(queryString.toString());
                while (rs.next()) {
                    String[] ot = rs.getString(1).split(",");
                    int i = 0;
                    while (i < ot.length) {
                        String s = ot[i].trim();
                        if (!s.equals("")) {
                            ret.add(s);
                        }
                        ++i;
                    }
                }
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                if (stmt != null) {
                    stmt.close();
                }
                if (rs == null) throw throwable;
                rs.close();
                throw throwable;
            }
            {
                Object var9_12 = null;
                if (stmt != null) {
                    stmt.close();
                }
                if (rs == null) return ret;
                rs.close();
                return ret;
            }
        }
        catch (SQLException e) {
            throw new ConsumerException("Internal Error in SSR.initialize(): " + e.getMessage(), e);
        }
    }
}

