/*
 * Decompiled with CFR 0.152.
 */
package org.egso.consumer.ssr;

import java.util.Iterator;
import org.egso.consumer.EGSOLiterals;
import org.egso.consumer.api.ConsumerException;
import org.egso.consumer.api.Data;
import org.egso.consumer.api.Interval;
import org.egso.consumer.api.ScalarData;
import org.egso.consumer.core.AbstractParameter;
import org.egso.consumer.core.GenericQuery;
import org.egso.consumer.core.Updator;
import org.egso.consumer.ssr.SSRLoader;
import org.egso.consumer.ssr.query.SSRQuery;
import org.egso.consumer.types.IntervalData;
import org.egso.consumer.types.StringData;

class SSRQuerySourceUpdator
implements Updator,
EGSOLiterals {
    String tableName = null;
    String dataKey = null;
    private static SSRQuery ssrQuery = new SSRQuery();

    public SSRQuerySourceUpdator(String dataKey) {
        this.dataKey = dataKey;
        SSRLoader ssrLoader = SSRLoader.getInstance();
        this.tableName = ssrLoader.getTableName();
    }

    public Data update(GenericQuery query, AbstractParameter param) throws ConsumerException {
        String fKey = null;
        fKey = this.dataKey.startsWith("observable_entity_type") ? "observable_entity_type" : (this.dataKey.startsWith("observing_type") ? "observing_type" : this.dataKey);
        StringBuffer queryString = new StringBuffer().append("SELECT DISTINCT ").append(fKey).append(" FROM ").append(this.tableName);
        ssrQuery.reSet();
        Iterator paramIt = param.getDependsOn().iterator();
        while (paramIt.hasNext()) {
            AbstractParameter p = (AbstractParameter)((Object)paramIt.next());
            String curDataKey = p.getDataKey();
            Data currentData = query.get(curDataKey);
            if (currentData == null) continue;
            if (currentData.isList() && currentData.size() > 0) {
                String[] values = new String[currentData.size()];
                Iterator lit = currentData.elements().iterator();
                int i = 0;
                while (lit.hasNext()) {
                    Data subelem = (Data)lit.next();
                    values[i++] = subelem.id();
                }
                ssrQuery.setField(curDataKey, values);
                continue;
            }
            if (currentData instanceof Interval) {
                IntervalData interval = (IntervalData)currentData;
                IntervalData.IntervalType intervalType = (IntervalData.IntervalType)interval.type();
                ScalarData min = interval.getMin();
                ScalarData max = interval.getMax();
                if (min == null && max == null) continue;
                if (min != null) {
                    ssrQuery.setField(intervalType.KEYS().min(), min.id());
                }
                if (max == null) continue;
                ssrQuery.setField(intervalType.KEYS().max(), max.id());
                continue;
            }
            String value = currentData.id();
            if (value == null) continue;
            ssrQuery.setField(curDataKey, value);
        }
        if (ssrQuery.isSet()) {
            queryString.append(" WHERE ").append(ssrQuery.getSQLQuery()).append(";");
        }
        return new StringData(queryString.toString());
    }
}

