/*
 * Decompiled with CFR 0.152.
 */
package org.egso.consumer.ssr.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class SSRQuery {
    public static final String MT_REMOTE = "remote";
    public static final String MT_INSITU = "insitu";
    public static final String OE_CAT_PHOTONS = "photons";
    public static final String OE_CAT_PARTICLES = "particles";
    public static final String OE_CAT_FIELDS = "fields";
    private QueryNode root = null;
    private FieldSet instrument = null;
    private FieldSet observatory = null;
    private FieldSet observatoryLocation = null;
    private FieldSet odCat = null;
    private FieldSet odType = null;
    private Constant mtRemote = null;
    private Constant mtInsitu = null;
    private FieldSet oeCat = null;
    private FieldSet oeType = null;
    private FieldSet oeTypeRemote = null;
    private FieldSet oeTypeInsitu = null;
    private Field startDate = null;
    private Field endDate = null;
    private FieldSet obsType = null;
    private FieldSet obsTypeRemote = null;
    private FieldSet obsTypeInsitu = null;

    public SSRQuery() {
        this.initialize();
    }

    private void initialize() {
        this.instrument = new FieldSet("instrument");
        this.observatory = new FieldSet("observatory");
        this.observatoryLocation = new FieldSet("observatory_location");
        this.odCat = new FieldSet("observing_domain_cat");
        this.odType = new FieldSet("observing_domain_type");
        this.mtRemote = new Constant("measurement_type", MT_REMOTE);
        this.mtInsitu = new Constant("measurement_type", MT_INSITU);
        this.oeCat = new FieldSet("observable_entity_cat");
        this.oeType = new FieldSet("observable_entity_type");
        this.oeTypeRemote = new FieldSet("observable_entity_type");
        this.oeTypeInsitu = new FieldSet("observable_entity_type");
        this.startDate = new Field("time_start", null, ">");
        this.endDate = new Field("time_end", null, "<");
        this.obsType = new FieldSet("observing_type", "LIKE");
        this.obsTypeRemote = new FieldSet("observing_type", "LIKE");
        this.obsTypeInsitu = new FieldSet("observing_type", "LIKE");
        this.root = new AND().addChild(new OR().addChild(new AND().addChild(new AND().addChild(this.obsTypeInsitu)).addChild(new OR().addChild(this.oeTypeInsitu))).addChild(new AND().addChild(new AND().addChild(this.obsTypeRemote)).addChild(new OR().addChild(this.oeTypeRemote)))).addChild(new OR().addChild(this.instrument)).addChild(new OR().addChild(this.observatory)).addChild(new OR().addChild(this.observatoryLocation)).addChild(new AND().addChild(this.obsType)).addChild(new OR().addChild(this.odType)).addChild(new OR().addChild(this.odCat)).addChild(new XOR().addChild(this.mtInsitu).addChild(this.mtRemote));
    }

    public String getSQLQuery() {
        return this.root.sqlFragment().toString();
    }

    public void reSet() {
        this.root.reSet();
    }

    public boolean isSet() {
        return this.root.isSet();
    }

    public void setField(String fieldName, String value) {
        if (fieldName.equals("measurement_type")) {
            if (value.equals(MT_INSITU)) {
                this.mtInsitu.set();
                this.mtRemote.reSet();
            }
            if (value.equals(MT_REMOTE)) {
                this.mtRemote.set();
                this.mtInsitu.reSet();
            }
        } else if (fieldName.equals("time_start")) {
            this.startDate.setValue(value);
        } else if (fieldName.equals("time_end")) {
            this.endDate.setValue(value);
        } else {
            this.setField(fieldName, new String[]{value});
        }
    }

    public void setField(String fieldName, String[] values) {
        if (fieldName.equals("observing_domain_type")) {
            this.odType.setValues(values);
        } else if (fieldName.equals("observing_domain_cat")) {
            this.odCat.setValues(values);
        } else if (fieldName.equals("observable_entity_cat")) {
            this.oeCat.setValues(values);
        } else if (fieldName.equals("observable_entity_type")) {
            this.oeType.setValues(values);
        } else if (fieldName.equals("observable_entity_type_insitu")) {
            this.oeTypeInsitu.setValues(values);
        } else if (fieldName.equals("observable_entity_type_remote")) {
            this.oeTypeRemote.setValues(values);
        } else if (fieldName.equals("observing_type_insitu")) {
            String[] val = new String[values.length];
            int i = 0;
            while (i < val.length) {
                val[i] = "%" + values[i] + "%";
                ++i;
            }
            this.obsTypeInsitu.setValues(val);
        } else if (fieldName.equals("observing_type_remote")) {
            String[] val = new String[values.length];
            int i = 0;
            while (i < val.length) {
                val[i] = "%" + values[i] + "%";
                ++i;
            }
            this.obsTypeRemote.setValues(val);
        } else if (fieldName.equals("observing_type")) {
            String[] val = new String[values.length];
            int i = 0;
            while (i < val.length) {
                val[i] = "%" + values[i] + "%";
                ++i;
            }
            this.obsType.setValues(val);
        } else if (fieldName.equals("instrument")) {
            this.instrument.setValues(values);
        } else if (fieldName.equals("observatory")) {
            this.observatory.setValues(values);
        } else if (fieldName.equals("observatory_location")) {
            this.observatoryLocation.setValues(values);
        } else if (fieldName.equals("measurement_type")) {
            if (values.length == 1) {
                this.setField(fieldName, values[0]);
            }
        } else {
            throw new IllegalArgumentException("Unknown fieldName: '" + fieldName + "'");
        }
    }

    interface QueryNode {
        public boolean isSet();

        public void reSet();

        public StringBuffer sqlFragment();
    }

    abstract class LogicOperator
    implements QueryNode {
        protected static final String OP_AND = "AND";
        protected static final String OP_OR = "OR";
        protected int numOfSetChildren = 0;
        protected List children = new ArrayList();

        public LogicOperator(int numOfSetChildren) {
            this.numOfSetChildren = numOfSetChildren;
        }

        public LogicOperator addChild(QueryNode queryNode) {
            if (queryNode == null) {
                throw new NullPointerException("Param QueryNode must not be null");
            }
            this.children.add(queryNode);
            return this;
        }

        public List getChildren() {
            return this.children;
        }

        public boolean isSet() {
            int count = 0;
            Iterator iter = this.children.iterator();
            while (iter.hasNext()) {
                QueryNode child = (QueryNode)iter.next();
                if (child.isSet()) {
                    ++count;
                }
                if (count < this.numOfSetChildren) continue;
                return true;
            }
            return false;
        }

        protected StringBuffer sqlFragment(String operator) {
            StringBuffer sb = new StringBuffer().append("(");
            boolean first = true;
            Iterator iter = this.children.iterator();
            while (iter.hasNext()) {
                QueryNode node = (QueryNode)iter.next();
                if (!node.isSet()) continue;
                if (first) {
                    first = false;
                } else {
                    sb.append(" ").append(operator).append(" ");
                }
                boolean firstInCol = true;
                if (node instanceof Collection) {
                    sb.append("(");
                    Iterator iterator = ((Collection)((Object)node)).iterator();
                    while (iterator.hasNext()) {
                        QueryNode colNode = (QueryNode)iterator.next();
                        if (firstInCol) {
                            firstInCol = false;
                        } else {
                            sb.append(" ").append(operator).append(" ");
                        }
                        sb.append(colNode.sqlFragment());
                    }
                    sb.append(")");
                    continue;
                }
                sb.append(node.sqlFragment());
            }
            sb.append(")");
            return sb;
        }

        public void reSet() {
            Iterator iter = this.children.iterator();
            while (iter.hasNext()) {
                QueryNode node = (QueryNode)iter.next();
                node.reSet();
            }
        }
    }

    class Switcher
    extends LogicOperator {
        private QueryNode switchValue = null;

        public Switcher(QueryNode switchValue) {
            super(1);
            this.switchValue = switchValue;
        }

        public boolean isSet() {
            if (this.children.size() == 1) {
                return this.switchValue.isSet() && ((QueryNode)this.children.get(0)).isSet();
            }
            throw new IllegalArgumentException("A Switcher must have only one child.");
        }

        public StringBuffer sqlFragment() {
            if (this.children.size() == 1) {
                return super.sqlFragment("AND");
            }
            throw new IllegalArgumentException("A Switcher must have only one child.");
        }
    }

    class AND
    extends LogicOperator {
        public AND() {
            super(1);
        }

        public AND(int numOfSetChildren) {
            super(numOfSetChildren);
        }

        public StringBuffer sqlFragment() {
            if (this.children.size() == 0) {
                return new StringBuffer();
            }
            return super.sqlFragment("AND");
        }
    }

    class OR
    extends LogicOperator {
        public OR() {
            super(1);
        }

        public OR(int numOfSetChildren) {
            super(numOfSetChildren);
        }

        public StringBuffer sqlFragment() {
            if (this.children.size() == 0) {
                return new StringBuffer();
            }
            return super.sqlFragment("OR");
        }
    }

    class XOR
    extends LogicOperator {
        public XOR() {
            super(0);
        }

        public boolean isSet() {
            int childCount = 0;
            Iterator iter = this.children.iterator();
            while (iter.hasNext()) {
                QueryNode child = (QueryNode)iter.next();
                if (!child.isSet()) continue;
                ++childCount;
            }
            return childCount != 0 && childCount != this.children.size();
        }

        public StringBuffer sqlFragment() {
            if (!this.isSet()) {
                return new StringBuffer();
            }
            return super.sqlFragment("OR");
        }
    }

    class NOT_XOR
    extends XOR {
        public StringBuffer sqlFragment() {
            if (!this.isSet()) {
                return new StringBuffer();
            }
            String operator = "OR";
            StringBuffer sb = new StringBuffer().append("(");
            boolean first = true;
            Iterator iter = this.children.iterator();
            while (iter.hasNext()) {
                QueryNode node = (QueryNode)iter.next();
                if (node.isSet()) continue;
                if (first) {
                    first = false;
                } else {
                    sb.append(" ").append(operator).append(" ");
                }
                boolean firstInCol = true;
                if (node instanceof Collection) {
                    sb.append("(");
                    Iterator iterator = ((Collection)((Object)node)).iterator();
                    while (iterator.hasNext()) {
                        QueryNode colNode = (QueryNode)iterator.next();
                        if (firstInCol) {
                            firstInCol = false;
                        } else {
                            sb.append(" ").append(operator).append(" ");
                        }
                        sb.append(colNode.sqlFragment());
                    }
                    sb.append(")");
                    continue;
                }
                sb.append(node.sqlFragment());
            }
            sb.append(")");
            return sb;
        }
    }

    class FieldSet
    extends ArrayList
    implements QueryNode {
        private String field = null;
        private String operator = "=";

        public FieldSet() {
        }

        public FieldSet(String field) {
            this.field = field;
        }

        public FieldSet(String field, String operator) {
            this.field = field;
            this.operator = operator;
        }

        public FieldSet(String field, String[] values, String operator) {
            this(field, operator);
            this.setValues(values);
        }

        public void setValues(String[] values) {
            if (this.field == null) {
                throw new NullPointerException("Field must be set before setting values.");
            }
            int i = 0;
            while (i < values.length) {
                this.add(new Field(this.field, values[i], this.operator));
                ++i;
            }
        }

        public boolean isSet() {
            Iterator iter = this.iterator();
            while (iter.hasNext()) {
                QueryNode node = (QueryNode)iter.next();
                if (!node.isSet()) continue;
                return true;
            }
            return false;
        }

        public void reSet() {
            this.clear();
        }

        public StringBuffer sqlFragment() {
            throw new IllegalStateException("Method FieldLeaveSet.sqlFragment() must not be called");
        }
    }

    abstract class AbstractLeaf
    implements QueryNode {
        protected String field = null;

        public AbstractLeaf() {
        }

        public AbstractLeaf(String fieldName) {
            this.field = fieldName;
        }

        public String getField() {
            return this.field;
        }

        public void setField(String field) {
            this.field = field;
        }
    }

    class Field
    extends AbstractLeaf {
        public static final String OPERATOR_EQUALS = "=";
        public static final String OPERATOR_LESSTHAN = "<";
        public static final String OPERATOR_GREATERTHAN = ">";
        public static final String OPERATOR_LIKE = "LIKE";
        public static final String FIELD_ESCAPE = "";
        private String value = null;
        private String operator = "=";

        public Field(String fieldName) {
            super(fieldName);
        }

        public Field(String fieldName, String value) {
            super(fieldName);
            this.value = value;
        }

        public Field(String fieldName, String value, String operator) {
            super(fieldName);
            this.value = value;
            this.operator = operator;
        }

        public boolean isSet() {
            return this.field != null && this.value != null;
        }

        public StringBuffer sqlFragment() {
            StringBuffer sb = new StringBuffer();
            if (this.value == null || this.field == null) {
                return sb;
            }
            sb.append(FIELD_ESCAPE).append(this.field).append(FIELD_ESCAPE).append(" ").append(this.operator).append(" '").append(this.value).append("' ");
            return sb;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getOperator() {
            return this.operator;
        }

        public void setOperator(String operator) {
            if (!(OPERATOR_EQUALS.equals(operator) || OPERATOR_GREATERTHAN.equals(operator) || OPERATOR_LESSTHAN.equals(operator))) {
                throw new IllegalArgumentException("Operator must be in ['=', '<', '>']");
            }
        }

        public void reSet() {
            this.value = null;
        }
    }

    class Constant
    extends Field {
        private boolean set = false;

        public Constant(String field, String value) {
            super(field, value);
        }

        public boolean isSet() {
            return this.set;
        }

        public void set() {
            this.set = true;
        }

        public void reSet() {
            this.set = false;
        }

        public void setValue(String value) {
            if (this.getValue() != null) {
                throw new IllegalArgumentException("Unallowed attempt to set a constants value");
            }
            super.setValue(value);
        }
    }
}

