/*
 * Decompiled with CFR 0.152.
 */
package org.egso.consumer.types;

import org.egso.consumer.api.ArgumentException;
import org.egso.consumer.api.ConsumerException;
import org.egso.consumer.api.Data;
import org.egso.consumer.api.ImmutableException;
import org.egso.consumer.api.Type;
import org.egso.consumer.types.ObjectData;

public class BooleanData
extends ObjectData
implements Data {
    private static BooleanType instance = null;

    public BooleanData() throws ArgumentException {
        this((BooleanType)null);
    }

    protected BooleanData(BooleanType type) throws ArgumentException {
        super(type != null ? type : BooleanData.getBooleanType());
    }

    protected BooleanData(BooleanType type, Object value) throws ConsumerException {
        this(type);
        this.setValue(value);
    }

    public BooleanData(Object initialValue) throws ConsumerException {
        this(null, initialValue);
    }

    public BooleanData(boolean initialValue) throws ArgumentException {
        this();
        this.setVal(initialValue);
    }

    public void setValue(Object value) throws ArgumentException {
        if (value instanceof BooleanData) {
            this.setValue(((BooleanData)value).get());
        } else if (value instanceof Boolean) {
            super.setValue(value);
        } else {
            throw new ArgumentException("value NOT Boolean");
        }
    }

    public boolean getVal() {
        return (Boolean)this.get();
    }

    public void setVal(boolean value) throws ArgumentException {
        super.setValue(new Boolean(value));
    }

    public String toString() {
        return "BooleanData(" + super.toString() + ")";
    }

    public String id() {
        return "" + this.getVal();
    }

    public static synchronized BooleanType getBooleanType() {
        if (instance == null) {
            try {
                instance = new BooleanType();
            }
            catch (ArgumentException argumentException) {
                // empty catch block
            }
        }
        return instance;
    }

    public static class BooleanType
    extends ObjectData.ObjectType
    implements Type {
        private BooleanType() throws ArgumentException {
            super("type_boolean");
            try {
                this.setNeutralData(new BooleanData(this));
            }
            catch (ImmutableException ex) {
                this.getLogger().warn((Object)("unexpected " + (Object)((Object)ex)), (Throwable)((Object)ex));
            }
        }

        public synchronized String toString() {
            return "BooleanData.BooleanType(" + super.toString() + ")";
        }
    }
}

