/*
 * Decompiled with CFR 0.152.
 */
package org.egso.consumer.types;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.egso.consumer.api.ArgumentException;
import org.egso.consumer.api.ConsumerException;
import org.egso.consumer.api.Data;
import org.egso.consumer.api.ImmutableException;
import org.egso.consumer.api.ScalarData;
import org.egso.consumer.api.ScalarType;
import org.egso.consumer.api.Type;
import org.egso.consumer.core.GenericData;
import org.egso.consumer.core.GenericType;
import org.egso.consumer.core.UncheckedConsumerException;
import org.egso.consumer.util.Convert;

public class DateData
extends GenericData
implements ScalarData,
Data {
    private static DateType dateType;
    private Calendar time = null;

    public static synchronized GenericType getDateType() {
        if (dateType == null) {
            try {
                dateType = new DateType();
            }
            catch (ArgumentException argumentException) {
                // empty catch block
            }
        }
        return dateType;
    }

    public DateData() throws ArgumentException {
        this((DateType)null);
    }

    protected DateData(DateType type) throws ArgumentException {
        super(type != null ? type : DateData.getDateType());
    }

    protected DateData(DateType type, Object value) throws ConsumerException {
        this(type);
        this.setValue(value);
    }

    public DateData(Object initialValue) throws ConsumerException {
        this(null, initialValue);
    }

    public synchronized void setValue(Object value) throws ConsumerException {
        if (value instanceof DateData) {
            this.time = ((DateData)value).getTime();
        } else if (value instanceof Long) {
            if (this.time == null) {
                this.time = GregorianCalendar.getInstance();
            }
            this.time.setTimeInMillis((Long)value);
        } else if (value instanceof Date) {
            if (this.time == null) {
                this.time = GregorianCalendar.getInstance();
            }
            this.time.setTime((Date)value);
        } else if (value instanceof Calendar) {
            this.time = (Calendar)value;
        } else if (value instanceof String) {
            if ("".equalsIgnoreCase((String)value) || "null".equalsIgnoreCase((String)value) || "n/a".equalsIgnoreCase((String)value)) {
                this.time = null;
            } else {
                boolean conversion_success;
                if (this.time == null) {
                    this.time = GregorianCalendar.getInstance();
                }
                if (!(conversion_success = false)) {
                    try {
                        long timeInMs = Long.parseLong((String)value);
                        this.time.setTimeInMillis(timeInMs);
                        conversion_success = true;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (!conversion_success) {
                    try {
                        this.time = Convert.str2calendar((String)value);
                        conversion_success = true;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                    }
                    catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                }
                if (!conversion_success) {
                    try {
                        this.time.setTime(DateFormat.getDateInstance().parse((String)value));
                        conversion_success = true;
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                }
                if (!conversion_success) {
                    this.time = null;
                    throw new ArgumentException("could not convert '" + value + "' into a date");
                }
            }
        } else {
            super.setValue(value);
        }
        this.checkInValueDomain();
    }

    public synchronized Calendar getTime() {
        return this.time;
    }

    public synchronized String id() {
        if (this.time == null) {
            return null;
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return format.format(this.time.getTime());
    }

    public synchronized String toString() {
        return "DateData(timevalue=" + this.id() + " " + super.toString() + ")";
    }

    public final boolean equalsNr(GenericData otherObject) {
        if (!(otherObject instanceof DateData)) {
            return false;
        }
        return this.equalsNr((DateData)otherObject);
    }

    protected boolean equalsNr(DateData otherDate) {
        if (this.time == null || otherDate.time == null) {
            return this.time == otherDate.time;
        }
        return this.time.equals(otherDate.time);
    }

    public int compareTo(Object o) {
        if (!(o instanceof DateData)) {
            throw new UncheckedConsumerException(new ArgumentException("wrong object to compare"));
        }
        try {
            return this.compareTo((DateData)o);
        }
        catch (ArgumentException ex) {
            throw new UncheckedConsumerException(ex);
        }
    }

    public int compareTo(DateData other) throws ArgumentException {
        if (other == null) {
            throw new ArgumentException("error: other == null");
        }
        if (this.time == null) {
            throw new ArgumentException("error: time == null");
        }
        if (this.time.before(other)) {
            return -1;
        }
        if (this.time.after(other)) {
            return 1;
        }
        return 0;
    }

    public synchronized Object getValue() {
        return this.time;
    }

    public static class DateType
    extends GenericType
    implements ScalarType,
    Type {
        public DateType() throws ArgumentException {
            super("type_date");
            try {
                this.setNeutralData(new DateData(this));
            }
            catch (ImmutableException ex) {
                this.getLogger().warn((Object)("unesxpected " + (Object)((Object)ex)), (Throwable)((Object)ex));
            }
        }

        public synchronized String toString() {
            return "DateData.DateType(" + super.toString() + ")";
        }
    }
}

