/*
 * Decompiled with CFR 0.152.
 */
package org.egso.consumer.types;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.egso.consumer.api.ArgumentException;
import org.egso.consumer.api.ConsumerException;
import org.egso.consumer.api.Data;
import org.egso.consumer.api.ImageReader;
import org.egso.consumer.api.ImmutableException;
import org.egso.consumer.api.Type;
import org.egso.consumer.core.GenericData;
import org.egso.consumer.core.GenericType;
import org.egso.consumer.types.ObjectData;

public class ImageData
extends GenericData
implements Data,
ImageReader {
    public static final String URL = "url";

    public ImageData() throws ArgumentException {
        this((ImageType)null);
    }

    protected ImageData(ImageType type) throws ArgumentException {
        super(type != null ? type : new ImageType());
    }

    protected ImageData(ImageType type, Object value) throws ConsumerException {
        this(type);
        this.setValue(value);
    }

    public ImageData(Object initialValue) throws ConsumerException {
        this(null, initialValue);
    }

    public void setValue(Object value) throws ConsumerException {
        if (value instanceof ImageData) {
            this.put(URL, ((ImageData)value).get(URL));
        } else if (value instanceof URL) {
            this.put(URL, value);
        } else if (value instanceof String) {
            try {
                this.setValue(new URL((String)value));
            }
            catch (MalformedURLException ex) {
                throw new ArgumentException(ex);
            }
        } else {
            throw new ArgumentException("value NOT Image");
        }
        this.checkInValueDomain();
    }

    public URL getImageURL() throws ConsumerException {
        return (URL)((ObjectData)this.get(URL)).get();
    }

    public void setImageURL(URL url) throws ConsumerException {
        this.put(URL, url);
    }

    public InputStream openStream() throws ConsumerException, IOException {
        return this.getImageURL().openStream();
    }

    public String toString() {
        return "ImageData(" + super.toString() + ")";
    }

    public synchronized Object getValue() throws ConsumerException {
        return this.getImageURL();
    }

    public static class ImageType
    extends GenericType
    implements Type {
        protected ImageType(String typeName) throws ArgumentException {
            super(typeName);
            this.childrenTypes().put(ImageData.URL, ObjectData.getObjectType());
            try {
                this.setNeutralData(new ImageData(this));
            }
            catch (ImmutableException ex) {
                this.getLogger().warn((Object)("unexpected " + (Object)((Object)ex)), (Throwable)((Object)ex));
            }
        }

        private ImageType() throws ArgumentException {
            this("type_image");
        }

        public synchronized String toString() {
            return "ImageData.ImageType(" + super.toString() + ")";
        }
    }
}

