/*
 * Decompiled with CFR 0.152.
 */
package org.egso.consumer.types;

import org.egso.consumer.api.ArgumentException;
import org.egso.consumer.api.ConsumerException;
import org.egso.consumer.api.Data;
import org.egso.consumer.api.ImmutableException;
import org.egso.consumer.api.Interval;
import org.egso.consumer.api.ScalarData;
import org.egso.consumer.api.ScalarType;
import org.egso.consumer.api.Type;
import org.egso.consumer.core.GenericData;
import org.egso.consumer.core.GenericType;
import org.egso.consumer.core.UncheckedConsumerException;
import org.egso.consumer.types.BooleanData;

public class IntervalData
extends GenericData
implements Data,
Interval {
    public IntervalData(GenericType type) throws ArgumentException {
        this(new IntervalType(type));
    }

    protected IntervalData(IntervalType type) throws ArgumentException {
        super(type);
        this.setMinIncl(true);
        this.setMaxIncl(true);
    }

    public IntervalData(GenericType type, ScalarData min, ScalarData max, boolean minIncl, boolean maxIncl) throws ConsumerException {
        this(type);
        if (min != null) {
            this.setMin(min);
        }
        if (max != null) {
            this.setMax(max);
        }
        this.setMinIncl(minIncl);
        this.setMaxIncl(maxIncl);
    }

    public synchronized String toString() {
        return "IntervalData(min=" + this.getMin() + " max=" + this.getMax() + " minincl=" + this.getMinInclusive() + " maxincl=" + this.getMaxInclusive() + " " + super.toString() + ")";
    }

    public synchronized ScalarData getMin() {
        return (ScalarData)this.children().get(((IntervalType)this.type()).KEYS().min());
    }

    public synchronized ScalarData getMax() {
        return (ScalarData)this.children().get(((IntervalType)this.type()).KEYS().max());
    }

    public synchronized boolean getMinInclusive() {
        return ((BooleanData)this.children().get(((IntervalType)this.type()).KEYS().minIncl())).getVal();
    }

    public synchronized boolean getMaxInclusive() {
        return ((BooleanData)this.children().get(((IntervalType)this.type()).KEYS().maxIncl())).getVal();
    }

    public synchronized void setMax(Object max) throws ConsumerException {
        this.put(((IntervalType)this.type()).KEYS().max(), max);
    }

    public synchronized void setMaxIncl(boolean maxIncl) {
        try {
            this.put(((IntervalType)this.type()).KEYS().maxIncl(), new BooleanData(maxIncl));
        }
        catch (ArgumentException ex) {
            this.getLogger().error((Object)"booleans are always valid, but:", (Throwable)((Object)ex));
            throw new UncheckedConsumerException(ex);
        }
    }

    public synchronized void setMaxIncl(Object maxIncl) throws ConsumerException {
        this.put(((IntervalType)this.type()).KEYS().maxIncl(), new BooleanData(maxIncl));
    }

    public synchronized void setMin(Object min) throws ConsumerException {
        this.put(((IntervalType)this.type()).KEYS().min(), min);
    }

    public synchronized void setMinIncl(boolean minIncl) {
        try {
            this.put(((IntervalType)this.type()).KEYS().minIncl(), new BooleanData(minIncl));
        }
        catch (ArgumentException ex) {
            this.getLogger().error((Object)"booleans are always valid, but:", (Throwable)((Object)ex));
            throw new UncheckedConsumerException(ex);
        }
    }

    public synchronized void setMinIncl(Object minIncl) throws ConsumerException {
        this.put(((IntervalType)this.type()).KEYS().minIncl(), new BooleanData(minIncl));
    }

    public synchronized void add(Object value) throws ConsumerException {
        if (this.getMin() == null) {
            this.setMin(value);
            return;
        }
        if (this.getMax() == null) {
            this.setMax(value);
            return;
        }
        super.add(value);
    }

    public synchronized void setValue(Object value) throws ConsumerException {
        if (value instanceof String && ((IntervalType)this.type()).boundaryType instanceof ScalarType) {
            String stringValue = ((String)value).trim();
            String separator = ":";
            int colonpos = ((String)value).indexOf(separator);
            if (colonpos >= 0) {
                String left = stringValue.substring(0, colonpos);
                String right = stringValue.substring(colonpos + 1);
                this.setMin(left);
                this.setMinIncl(left.trim().length() > 0);
                this.setMax(right);
                this.setMaxIncl(left.trim().length() > 0);
            } else {
                separator = ",";
                colonpos = ((String)value).indexOf(separator);
                if (!(colonpos <= 0 || stringValue.charAt(0) != '[' && stringValue.charAt(0) != ']' || stringValue.charAt(stringValue.length() - 1) != '[' && stringValue.charAt(stringValue.length() - 1) != ']')) {
                    String left = stringValue.substring(1, colonpos);
                    String right = stringValue.substring(colonpos + 1, stringValue.length() - 1);
                    this.setMin(left);
                    boolean minincl = left.trim().length() > 0;
                    this.setMinIncl(minincl &= stringValue.charAt(0) == '[');
                    this.setMax(right);
                    boolean maxincl = left.trim().length() > 0;
                    this.setMaxIncl(maxincl &= stringValue.charAt(stringValue.length() - 1) == ']');
                } else if (colonpos > 0) {
                    String left = stringValue.substring(0, colonpos);
                    String right = stringValue.substring(colonpos + 1);
                    this.setMin(left);
                    this.setMax(right);
                } else {
                    this.setMin(value);
                    this.setMax(value);
                }
            }
        } else if (value instanceof Object[] && ((Object[])value).length == 2) {
            this.setMin(((Object[])value)[0]);
            this.setMax(((Object[])value)[1]);
        }
    }

    public boolean overlaps(Interval otherInterval) {
        ScalarData max2;
        ScalarData max1;
        ScalarData min2;
        ScalarData min1;
        IntervalData intervalData = this;
        synchronized (intervalData) {
            min1 = this.getMin();
            min2 = otherInterval.getMin();
            max1 = this.getMax();
            max2 = otherInterval.getMax();
        }
        return (min1 == null || max2 == null || min1.compareTo(max2) < 0) && (min2 == null || max1 == null || min2.compareTo(max1) < 0) || min1 != null && max2 != null && min1.equals(max2) && this.getMinInclusive() && otherInterval.getMaxInclusive() || min2 != null && max1 != null && min2.equals(max1) && this.getMaxInclusive() && otherInterval.getMinInclusive();
    }

    public boolean contains(Interval otherInterval) {
        ScalarData max2;
        ScalarData max1;
        ScalarData min2;
        ScalarData min1;
        IntervalData intervalData = this;
        synchronized (intervalData) {
            min1 = this.getMin();
            min2 = otherInterval.getMin();
            max1 = this.getMax();
            max2 = otherInterval.getMax();
        }
        return !(min1.compareTo(min2) >= 0 && (min1.compareTo(min2) != 0 || !this.getMinInclusive() && otherInterval.getMinInclusive()) || max2.compareTo(max1) >= 0 && (max1.compareTo(max2) != 0 || !this.getMaxInclusive() && otherInterval.getMaxInclusive()));
    }

    public boolean contains(ScalarData point) {
        ScalarData max;
        ScalarData min;
        IntervalData intervalData = this;
        synchronized (intervalData) {
            min = this.getMin();
            max = this.getMax();
        }
        if (min != null) {
            int comparison = point.compareTo(min);
            if (comparison < 0) {
                return false;
            }
            if (comparison == 0 && !this.getMinInclusive()) {
                return false;
            }
        }
        if (max != null) {
            int comparison = point.compareTo(max);
            if (comparison > 0) {
                return false;
            }
            if (comparison == 0 && !this.getMaxInclusive()) {
                return false;
            }
        }
        return true;
    }

    public boolean contains(Data candidate) throws ArgumentException {
        if (candidate instanceof Interval) {
            return this.contains((Interval)((Object)candidate));
        }
        if (candidate instanceof ScalarData) {
            return this.contains((ScalarData)candidate);
        }
        return super.contains(candidate);
    }

    public synchronized Object getValue() throws ConsumerException {
        return new Object[]{this.getMin().getValue(), this.getMax().getValue()};
    }

    public String id() {
        String superid = super.id();
        if (superid != null) {
            return superid;
        }
        IntervalData intervalData = this;
        synchronized (intervalData) {
            return String.valueOf(this.getMin() != null ? String.valueOf(this.getMinInclusive() ? "[" : "]") + this.getMin().id() : "") + ":" + (this.getMax() != null ? String.valueOf(this.getMax().id()) + (this.getMaxInclusive() ? "]" : "[") : "");
        }
    }

    public static interface Keys {
        public String min();

        public String max();

        public String minIncl();

        public String maxIncl();
    }

    public static class IntervalType
    extends GenericType
    implements Type {
        final GenericType boundaryType;
        private Keys myKeys = new DefaultKeys();

        public synchronized Keys KEYS() {
            return this.myKeys;
        }

        public IntervalType(String typeName, GenericType boundaryType, Keys mapping) throws ArgumentException {
            super(typeName);
            this.boundaryType = boundaryType;
            if (mapping != null) {
                if (mapping.minIncl() == null) {
                    throw new ArgumentException("intervaltype: 'minincl' key must not be null");
                }
                if (mapping.min() == null) {
                    throw new ArgumentException("intervaltype: 'min' key must not be null");
                }
                if (mapping.maxIncl() == null) {
                    throw new ArgumentException("intervaltype: 'maxincl' key must not be null");
                }
                if (mapping.max() == null) {
                    throw new ArgumentException("intervaltype: 'min' key must not be null");
                }
                this.myKeys = mapping;
            }
            this.childrenTypes().put(this.KEYS().min(), boundaryType);
            this.childrenTypes().put(this.KEYS().max(), boundaryType);
            this.childrenTypes().put(this.KEYS().minIncl(), new BooleanData().type());
            this.childrenTypes().put(this.KEYS().maxIncl(), new BooleanData().type());
            try {
                this.setNeutralData(new IntervalData(this));
            }
            catch (ImmutableException ex) {
                this.getLogger().warn((Object)("unexpected " + (Object)((Object)ex)), (Throwable)((Object)ex));
            }
        }

        public IntervalType(String typeName, GenericType boundaryType) throws ArgumentException {
            this(typeName, boundaryType, null);
        }

        public IntervalType(GenericType boundaryType) throws ArgumentException {
            this(String.valueOf(boundaryType.typeName()) + "_interval", boundaryType);
        }

        public synchronized Type elementsType() {
            return this.boundaryType;
        }

        public boolean isList() {
            return false;
        }

        public synchronized String toString() {
            return "IntervalData.IntervalType(boundaryType=" + this.boundaryType + " " + super.toString() + ")";
        }

        public static class DefaultKeys
        implements Keys {
            public String min() {
                return "min";
            }

            public String max() {
                return "max";
            }

            public String minIncl() {
                return "min-incl";
            }

            public String maxIncl() {
                return "max-incl";
            }
        }
    }
}

