/*
 * Decompiled with CFR 0.152.
 */
package org.egso.consumer.types;

import org.egso.consumer.api.ArgumentException;
import org.egso.consumer.api.Data;
import org.egso.consumer.api.ImmutableException;
import org.egso.consumer.api.Type;
import org.egso.consumer.core.GenericData;
import org.egso.consumer.core.GenericType;

public class ObjectData
extends GenericData
implements Data {
    Object value = null;
    private static ObjectType instance;

    public synchronized Object getValue() {
        return this.value;
    }

    public ObjectData() throws ArgumentException {
        this((ObjectType)null);
    }

    protected ObjectData(ObjectType type) throws ArgumentException {
        super(type != null ? type : new ObjectType());
    }

    protected ObjectData(ObjectType type, Object value) throws ArgumentException {
        this(type);
        this.setValue(value);
    }

    public ObjectData(Object initialValue) throws ArgumentException {
        this(null, initialValue);
    }

    public synchronized void setValue(Object value) throws ArgumentException {
        this.value = value;
    }

    public synchronized String toString() {
        return "ObjectData(value=" + this.value + " " + super.toString() + ")";
    }

    public synchronized Object get() {
        return this.value;
    }

    protected final boolean equalsNr(GenericData otherData) {
        if (!(otherData instanceof ObjectData)) {
            return false;
        }
        return this.equalsNr((ObjectData)otherData);
    }

    protected boolean equalsNr(ObjectData otherObject) {
        if (this.value == null || otherObject.value == null) {
            return this.value == otherObject.value;
        }
        return this.value.equals(otherObject.value);
    }

    public static synchronized GenericType getObjectType() {
        if (instance == null) {
            try {
                instance = new ObjectType();
            }
            catch (ArgumentException argumentException) {
                // empty catch block
            }
        }
        return instance;
    }

    public static class ObjectType
    extends GenericType
    implements Type {
        protected ObjectType(String typeName) throws ArgumentException {
            super(typeName);
            try {
                this.setNeutralData(new ObjectData(this));
            }
            catch (ImmutableException ex) {
                this.getLogger().warn((Object)("unexpected " + (Object)((Object)ex)), (Throwable)((Object)ex));
            }
        }

        private ObjectType() throws ArgumentException {
            this("type_object");
        }

        public synchronized String toString() {
            return "ObjectData.ObjectType(" + super.toString() + ")";
        }
    }
}

