/*
 * Decompiled with CFR 0.152.
 */
package org.egso.consumer.types.egso;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.egso.common.logging.AbstractLogEnabled;
import org.egso.consumer.EGSOLiterals;
import org.egso.consumer.api.ArgumentException;
import org.egso.consumer.api.ConsumerException;
import org.egso.consumer.config.CatalogConfig;
import org.egso.consumer.core.GenericType;

public final class EGSOTypesFactory
extends AbstractLogEnabled
implements EGSOLiterals {
    private static EGSOTypesFactory instance = new EGSOTypesFactory();
    private static boolean configured = false;
    private Map typemap = Collections.synchronizedMap(new HashMap());

    public static synchronized EGSOTypesFactory getInstance() {
        return instance;
    }

    public GenericType getType(String type_key) throws ArgumentException {
        GenericType type = (GenericType)this.typemap.get(type_key);
        if (type == null) {
            throw new ArgumentException("No type found for key '" + type_key + "'");
        }
        return type;
    }

    private EGSOTypesFactory() {
    }

    public void configure(List configs) throws ConsumerException {
        if (configured) {
            throw new IllegalStateException("Types Factory must not be configured twice");
        }
        configured = true;
        Iterator iter = configs.iterator();
        while (iter.hasNext()) {
            CatalogConfig catalog = (CatalogConfig)iter.next();
            Iterator iterator = catalog.getTypes().iterator();
            while (iterator.hasNext()) {
                GenericType type = (GenericType)iterator.next();
                this.putType(type);
            }
        }
    }

    private void putType(GenericType type) throws ArgumentException {
        GenericType chkType = (GenericType)this.typemap.get(type.typeName());
        if (chkType != null && chkType != type) {
            throw new ArgumentException("EGSOTypesFactory: duplicated type found: " + type.typeName());
        }
        this.typemap.put(type.typeName(), type);
    }
}

