/*
 * Decompiled with CFR 0.152.
 */
package org.egso.consumer.types.votable;

import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import org.egso.consumer.api.ArgumentException;
import org.egso.consumer.api.ConsumerException;
import org.egso.consumer.api.Data;
import org.egso.consumer.api.ImmutableException;
import org.egso.consumer.api.Type;
import org.egso.consumer.api.VOTableReader;
import org.egso.consumer.core.GenericData;
import org.egso.consumer.core.GenericType;
import org.egso.consumer.types.StringData;
import org.egso.consumer.types.votable.VOTableDataHandler;

public class VOTableData
extends GenericData
implements Data,
VOTableReader {
    private String votable = null;

    public VOTableData(VOTableType type, String voTable) throws ConsumerException {
        super(type);
        this.setValue(voTable);
    }

    public void setValue(Object value) throws ConsumerException {
        if (value == null) {
            this.votable = null;
            this.elements().clear();
            return;
        }
        if (!(value instanceof String)) {
            throw new ArgumentException("conversion from " + value.getClass() + " to String not supported yet.");
        }
        this.votable = (String)value;
        if (this.votable == null) {
            throw new ArgumentException("VOTableData must be initialized with valid vo table source but got: " + this.votable);
        }
        this.elements().clear();
        VOTableDataHandler.parse(this.votable, new VOTableDataHandler(this));
    }

    public Object getValue() throws ConsumerException {
        return this.votable;
    }

    public String toString() {
        return "VOTableData(" + super.toString() + " votable='" + this.votable + "')";
    }

    public Reader readVOTable() {
        if (this.votable == null) {
            return null;
        }
        return new StringReader(this.votable);
    }

    protected final boolean equalsNr(GenericData otherData) {
        if (!(otherData instanceof VOTableData)) {
            return false;
        }
        return this.equalsNr((VOTableData)otherData);
    }

    protected boolean equalsNr(VOTableData votData) {
        if (this.votable == null || votData.votable == null) {
            return this.votable == votData.votable;
        }
        return this.votable.equals(votData.votable);
    }

    protected Object cloneNr(GenericData gdClone) {
        ((VOTableData)gdClone).votable = this.votable;
        return super.cloneNr(gdClone);
    }

    public static class VOTableType
    extends GenericType
    implements Type {
        public static final String DESCRIPTION = "description";
        private Set joinSet;

        public Set getJoinSet() {
            return this.joinSet;
        }

        public VOTableType(String typeName, Set joinSet) throws ArgumentException {
            super(typeName);
            this.joinSet = joinSet;
            this.childrenTypes().put(DESCRIPTION, StringData.getStringType());
            try {
                this.setDistinct(false);
            }
            catch (ImmutableException ex) {
                this.getLogger().warn((Object)("UNEXPECTED: " + ex.getMessage()), (Throwable)((Object)ex));
            }
        }

        public VOTableType(String typeName, String[] joinArray) throws ArgumentException {
            this(typeName, (Set)null);
            this.joinSet = new LinkedHashSet<String>(Arrays.asList(joinArray));
        }

        public Data newData(Object initialValue) throws ConsumerException {
            GenericData newData = null;
            if (initialValue == null) {
                newData = new VOTableData(this, null);
                this.setNeutralData(newData);
            } else {
                newData = initialValue instanceof String ? new VOTableData(this, (String)initialValue) : (GenericData)super.newData(initialValue);
            }
            return newData;
        }

        public synchronized String toString() {
            return "VOTableDataVOTableType(" + super.toString() + ")";
        }
    }
}

