/*
 * Decompiled with CFR 0.152.
 */
package org.egso.consumer.types.votable;

import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.log4j.Logger;
import org.egso.common.logging.AbstractLogEnabled;
import org.egso.consumer.api.ArgumentException;
import org.egso.consumer.api.ConsumerException;
import org.egso.consumer.api.Data;
import org.egso.consumer.api.Type;
import org.egso.consumer.core.UncheckedConsumerException;
import org.egso.consumer.types.votable.VOTableData;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class VOTableDataHandler
extends DefaultHandler {
    public static final boolean verbose = false;
    public static final String NAMESPACE = "http://www.ivoa.net/xml/VOTable/v1.1";
    private VOTableData data;
    private List fieldList = new LinkedList();
    private Map fieldTypes = new HashMap();
    private Data rowData = null;
    private int colIndex = 0;
    private boolean intd = false;
    private StringBuffer tdc = null;
    private final Logger logger = new AbstractLogEnabled(){

        public Logger getLogger() {
            return super.getLogger();
        }
    }.getLogger();
    protected static SAXParser parser = null;

    public VOTableDataHandler(VOTableData dataToInit) throws ArgumentException {
        if (dataToInit == null) {
            throw new ArgumentException("SSRHandler::SSRHandler::dataToInit must not be null");
        }
        this.data = dataToInit;
        this.deepFindChildTypes(dataToInit.elementsType());
    }

    private void deepFindChildTypes(Type someType) {
        Iterator it = someType.childrenTypes().entrySet().iterator();
        while (it.hasNext()) {
            Type childType;
            Map.Entry entry = it.next();
            String childName = (String)entry.getKey();
            Type prev = this.fieldTypes.put(childName, childType = (Type)entry.getValue());
            if (prev != null) {
                if (prev.equals(childType) || !this.logger.isDebugEnabled()) continue;
                this.logger.debug((Object)("ambigous attribute type for '" + childName + "': " + prev + " just has been overwritten with " + childType));
                continue;
            }
            this.deepFindChildTypes(childType);
        }
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        uri.equals(qName);
        if ("FIELD".equals(localName)) {
            String name = attributes.getValue(NAMESPACE, "name");
            if (name == null) {
                name = attributes.getValue("name");
            }
            this.fieldList.add(name);
            if (this.fieldTypes.get(name) == null && this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("didn't find type for column/FIELD '" + name + "."));
            }
        } else if ("TR".equals(localName)) {
            this.colIndex = -1;
            try {
                this.rowData = this.data.elementsType().newData();
            }
            catch (ConsumerException ex) {
                throw new UncheckedConsumerException(ex);
            }
        } else if ("TD".equals(localName)) {
            this.tdc = new StringBuffer();
            this.intd = true;
            ++this.colIndex;
        } else if ("DESCRIPTION".equals(localName)) {
            this.tdc = new StringBuffer();
            this.intd = true;
            ++this.colIndex;
        }
    }

    public void characters(char[] ch, int start, int length) {
        if (this.intd) {
            this.tdc.append(ch, start, length);
        }
    }

    public void endElement(String uri, String localName, String qName) {
        uri.equals(qName);
        if ("TD".equals(localName)) {
            String content = this.tdc.toString().trim();
            this.intd = false;
            this.tdc = null;
            if (this.colIndex >= this.fieldList.size()) {
                UncheckedConsumerException ucex = new UncheckedConsumerException(new ConsumerException("encountered to many TDs within one TR: column " + (this.colIndex + 1)));
                this.logger.error((Object)ucex);
                throw ucex;
            }
            try {
                String colName = (String)this.fieldList.get(this.colIndex);
                Type cellType = (Type)this.fieldTypes.get(colName);
                if (cellType != null) {
                    Data cellData = cellType.newData(content);
                    this.apply(new LinkedList(), this.rowData.type(), this.rowData, colName, content, cellData, 5);
                }
                this.logger.warn((Object)("didn't find type for column/FIELD '" + colName + "': could not apply value '" + content + "', therefore."));
            }
            catch (ArgumentException ex) {
                this.logger.warn((Object)("could not apply TD value: '" + content + "' to " + (String)this.fieldList.get(this.colIndex) + ": " + ex.getMessage()), (Throwable)((Object)ex));
            }
            catch (ConsumerException ex) {
                throw new UncheckedConsumerException(ex);
            }
        } else {
            if ("TR".equals(localName)) {
                try {
                    this.data.add(this.rowData);
                }
                catch (ConsumerException ex) {
                    throw new UncheckedConsumerException(ex);
                }
            }
            if ("DESCRIPTION".equals(localName)) {
                String content = this.tdc.toString().trim();
                this.intd = false;
                this.tdc = null;
                try {
                    this.data.put("description", content);
                }
                catch (ArgumentException ex) {
                    throw new UncheckedConsumerException(ex);
                }
            }
        }
    }

    public static void parse(String is, DefaultHandler handler) throws ConsumerException {
        if (parser == null) {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setValidating(true);
            factory.setNamespaceAware(true);
            try {
                parser = factory.newSAXParser();
            }
            catch (ParserConfigurationException ex) {
                throw new ConsumerException("VOT: internal problem with SAX parser configuration: " + ex.getMessage(), ex);
            }
            catch (SAXException ex) {
                System.out.println("VO Table was: \n" + is);
                throw new ConsumerException("VOT: internal problem with SAX parser: " + ex.getMessage(), ex);
            }
        }
        try {
            parser.parse(new InputSource(new StringReader(is)), handler);
        }
        catch (SAXException ex) {
            throw new ConsumerException("VOT: internal problem with SAX parser: " + ex.getMessage(), ex);
        }
        catch (IOException ex) {
            throw new ConsumerException("VOT: problem while parsing with reading from stream: " + ex.getMessage(), ex);
        }
        catch (UncheckedConsumerException ex) {
            ex.unwrap();
        }
    }

    private void apply(List path, Type type, Data rootData, String key, Object value, Data cellData, int maxDepth) throws ConsumerException {
        if (maxDepth < 0) {
            return;
        }
        if (type.childrenTypes() != null) {
            Iterator it = type.childrenTypes().keySet().iterator();
            while (it.hasNext()) {
                String childKey = (String)it.next();
                if (childKey.equals(key)) {
                    Data someData = rootData;
                    Data undoData = null;
                    String undoKey = null;
                    Iterator pit = path.iterator();
                    while (pit.hasNext()) {
                        String k = (String)pit.next();
                        if (undoData == null) {
                            undoData = someData;
                        }
                        if (undoKey == null) {
                            undoKey = k;
                        }
                        if (someData.get(k) == null) {
                            someData.put(k, ((Type)someData.childrenTypes().get(k)).newData());
                        }
                        someData = someData.get(k);
                    }
                    try {
                        someData.put(key, cellData);
                    }
                    catch (ConsumerException ex) {
                        if (undoData != null && undoKey != null) {
                            undoData.put(undoKey, null);
                        }
                        throw ex;
                    }
                }
                path.add(childKey);
                this.apply(path, (Type)type.childrenTypes().get(childKey), rootData, key, value, cellData, maxDepth - 1);
                path.remove(path.size() - 1);
            }
        }
    }
}

