/*
 * Decompiled with CFR 0.152.
 */
package org.egso.consumer.util;

import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.SortedSet;
import java.util.TreeSet;
import org.egso.common.logging.AbstractLogEnabled;
import org.egso.consumer.api.ConsumerException;
import org.egso.consumer.api.async.Event;
import org.egso.consumer.api.async.EventSink;
import org.egso.consumer.api.async.EventSource;
import org.egso.consumer.util.AbstractEvent;

public class AbstractEventSource
extends AbstractLogEnabled
implements EventSource,
Cloneable {
    private LinkedList listeners = new LinkedList();
    TreeSet eventTree = null;
    private SortedSet eventlog = null;
    private boolean keepEvents = false;

    public AbstractEventSource() {
        this(false);
    }

    public AbstractEventSource(boolean recordEvents) {
        this.initEventLog(recordEvents);
    }

    public synchronized void initEventLog(boolean recordEvents) {
        if (this.keepEvents == recordEvents) {
            return;
        }
        this.keepEvents = recordEvents;
        if (recordEvents) {
            this.eventTree = new TreeSet(new Comparator(){

                public int compare(Object o1, Object o2) {
                    if (!(o1 instanceof AbstractEvent) || !(o2 instanceof AbstractEvent)) {
                        throw new RuntimeException((Throwable)((Object)new ConsumerException("only AbstractMapEvent objects are expected in the eventlog!")));
                    }
                    long diff = ((Event)o1).getTime() - ((Event)o2).getTime();
                    if (diff == 0L) {
                        if (o1.equals(o2)) {
                            return 0;
                        }
                        return ((AbstractEvent)o1).seq - ((AbstractEvent)o2).seq;
                    }
                    if (diff > 0L) {
                        return 1;
                    }
                    return -1;
                }
            });
            this.eventlog = Collections.synchronizedSortedSet(this.eventTree);
        } else {
            this.eventTree = null;
            this.eventlog = null;
        }
    }

    private void logEvent(Event event) {
        if (this.keepEvents) {
            this.eventlog.add(event);
        }
    }

    public void addListener(EventSink listener) {
        if (listener == null) {
            this.getLogger().warn((Object)"someone tried to register a listener == null!");
            return;
        }
        AbstractEventSource abstractEventSource = this;
        synchronized (abstractEventSource) {
            this.listeners.add(listener);
        }
    }

    public void removeListener(EventSink listener) {
        if (listener == null) {
            this.getLogger().warn((Object)"someone tried to unregister a listener == null!");
            return;
        }
        AbstractEventSource abstractEventSource = this;
        synchronized (abstractEventSource) {
            while (this.listeners.remove(listener)) {
            }
        }
    }

    public synchronized SortedSet eventLog(long since) {
        if (this.keepEvents) {
            if (since == 0L) {
                return Collections.unmodifiableSortedSet(this.eventlog);
            }
            return Collections.unmodifiableSortedSet(this.eventlog.subSet(new AbstractEvent(null, null, since), new AbstractEvent(null, null, Long.MAX_VALUE)));
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    protected void update(Event event) {
        var3_2 = this;
        synchronized (var3_2) {
            this.logEvent(event);
            it = new LinkedList<E>(this.listeners).iterator();
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl6 : MonitorExitStatement: MONITOREXIT : var3_2
            if (true) ** GOTO lbl13
        }
        do {
            sink = (EventSink)it.next();
            sink.notify(event);
lbl13:
            // 2 sources

        } while (it.hasNext());
    }

    public synchronized Object clone() {
        AbstractEventSource clone;
        try {
            clone = (AbstractEventSource)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            return null;
        }
        clone.listeners = (LinkedList)this.listeners.clone();
        if (this.eventTree != null) {
            clone.eventTree = (TreeSet)this.eventTree.clone();
        }
        if (this.eventlog != null) {
            clone.eventlog = Collections.synchronizedSortedSet(clone.eventTree);
        }
        return clone;
    }
}

