/*
 * Decompiled with CFR 0.152.
 */
package org.egso.consumer.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class Convert {
    private static SimpleDateFormat[] dateFormat = new SimpleDateFormat[]{new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS"), new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"), new SimpleDateFormat("yyyy-MM-dd")};

    public static long str2date(String date) throws IllegalArgumentException {
        return Convert.str2calendar(date).getTimeInMillis();
    }

    public static Calendar str2calendar(String date) throws IllegalArgumentException {
        Date parsedDate = null;
        int i = 0;
        while (i < dateFormat.length) {
            try {
                parsedDate = dateFormat[i].parse(date);
                if (parsedDate != null) {
                    break;
                }
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            ++i;
        }
        if (parsedDate == null) {
            throw new IllegalArgumentException("expected a date with format yyyy-MM-dd (HH:mm:ss(.SSS)?)?" + date);
        }
        TimeZone gmt = TimeZone.getTimeZone("GMT");
        Calendar c = GregorianCalendar.getInstance(gmt);
        c.setTimeInMillis(parsedDate.getTime());
        return c;
    }
}

