/*
 * Decompiled with CFR 0.152.
 */
package org.egso.consumer.valid;

import org.apache.log4j.Logger;
import org.egso.common.logging.AbstractLogEnabled;
import org.egso.consumer.api.ArgumentException;

public class CatNameValidator
extends AbstractLogEnabled {
    public static final int MAX_CATNAME_LENGTH = 63;
    private static Logger theLogger = new CatNameValidator().getLogger();

    private CatNameValidator() {
    }

    public static void validateCatalogueName(String catName) throws ArgumentException {
        if (catName == null) {
            ArgumentException aex = new ArgumentException("the catalogue name must not be null");
            if (theLogger.isDebugEnabled()) {
                theLogger.debug((Object)aex);
            }
            throw aex;
        }
        if ("".equals(catName)) {
            ArgumentException aex = new ArgumentException("the catalogue name must not be emtpy");
            if (theLogger.isDebugEnabled()) {
                theLogger.debug((Object)aex);
            }
            throw aex;
        }
        if (!catName.matches("[a-zA-Z0-9_:/.\\-]*")) {
            ArgumentException aex = new ArgumentException("illegal catalogue name '" + catName + "' contains illegal characters");
            if (theLogger.isDebugEnabled()) {
                theLogger.debug((Object)aex);
            }
            throw aex;
        }
        if (catName.length() > 63) {
            ArgumentException aex = new ArgumentException("catalogue name '" + catName + "' too long " + "(max " + 63 + " characters allowed)");
            if (theLogger.isDebugEnabled()) {
                theLogger.debug((Object)aex);
            }
            throw aex;
        }
    }
}

