/*
 * Decompiled with CFR 0.152.
 */
package org.egso.consumer.valid;

import org.apache.log4j.Logger;
import org.egso.common.logging.AbstractLogEnabled;
import org.egso.consumer.api.ArgumentException;

public class QueryNameValidator
extends AbstractLogEnabled {
    public static final int MAX_QUERYNAME_LENGTH = 63;
    private static Logger theLogger = new QueryNameValidator().getLogger();

    private QueryNameValidator() {
    }

    public static void validateQueryName(String queryname) throws ArgumentException {
        if (queryname == null) {
            ArgumentException aex = new ArgumentException("a query name must never be null");
            if (theLogger.isDebugEnabled()) {
                theLogger.debug((Object)aex);
            }
            throw aex;
        }
        if ("".equals(queryname)) {
            ArgumentException aex = new ArgumentException("a query name must not be emtpy");
            if (theLogger.isDebugEnabled()) {
                theLogger.debug((Object)aex);
            }
            throw aex;
        }
        if (!queryname.matches("[a-zA-Z0-9_:/.\\-]*")) {
            ArgumentException aex = new ArgumentException("illegal query name '" + queryname + "'");
            if (theLogger.isDebugEnabled()) {
                theLogger.debug((Object)aex);
            }
            throw aex;
        }
        if (queryname.length() > 63) {
            ArgumentException aex = new ArgumentException("query name '" + queryname + "' too long " + "(max " + 63 + " characters allowed)");
            if (theLogger.isDebugEnabled()) {
                theLogger.debug((Object)aex);
            }
            throw aex;
        }
    }
}

