/*
 * Decompiled with CFR 0.152.
 */
package org.egso.consumer.valid;

import org.apache.log4j.Logger;
import org.egso.common.logging.AbstractLogEnabled;
import org.egso.consumer.api.ArgumentException;

public class TypeNameValidator
extends AbstractLogEnabled {
    public static final int MAX_TYPENAME_LENGTH = 63;
    private static Logger theLogger = new TypeNameValidator().getLogger();

    private TypeNameValidator() {
    }

    public static void validateTypeName(String typename) throws ArgumentException {
        if (typename == null) {
            ArgumentException aex = new ArgumentException("a type name must never be null");
            if (theLogger.isDebugEnabled()) {
                theLogger.debug((Object)aex);
            }
            throw aex;
        }
        if ("".equals(typename)) {
            ArgumentException aex = new ArgumentException("a type name must not be emtpy");
            if (theLogger.isDebugEnabled()) {
                theLogger.debug((Object)aex);
            }
            throw aex;
        }
        if (!typename.matches("[a-zA-Z0-9_:/.\\-]*")) {
            ArgumentException aex = new ArgumentException("illegal typename '" + typename + "'");
            if (theLogger.isDebugEnabled()) {
                theLogger.debug((Object)aex);
            }
            throw aex;
        }
        if (typename.length() > 63) {
            ArgumentException aex = new ArgumentException("typename '" + typename + "' too long " + "(max " + 63 + " characters allowed)");
            if (theLogger.isDebugEnabled()) {
                theLogger.debug((Object)aex);
            }
            throw aex;
        }
    }
}

