/*
 * Decompiled with CFR 0.152.
 */
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import org.egso.common.context.EGSOContext;
import org.egso.consumer.EGSOLiterals;
import org.egso.consumer.api.Data;
import org.egso.consumer.api.Query;
import org.egso.consumer.api.async.Session;
import org.egso.consumer.wsclient.WSQuery;
import org.egso.consumer.wsclient.session.WSSessionFactory;

public class MostSimpleWebServiceMain
implements EGSOLiterals {
    public static void main(String[] args) throws Exception {
        URL endpoint = args.length == 1 ? new URL(args[0]) : new URL("http://localhost:8080/egso-ws/query");
        Session s = new WSSessionFactory(endpoint).login(null);
        Query q = s.newQuery();
        String id = q.id();
        System.out.println("query id = " + id);
        System.out.println("all param and result names = " + q.findAll());
        System.out.println("param names only = " + q.findAllParameters());
        System.out.println("result names only = " + q.findAllResults());
        Collection allParamNames = q.findAll();
        Iterator it = allParamNames.iterator();
        while (it.hasNext()) {
            String pName = (String)it.next();
            System.out.println(String.valueOf(pName) + " is affected by " + q.affectedBy(pName));
            System.out.println(String.valueOf(pName) + " affects " + q.affects(pName));
            System.out.println(String.valueOf(pName) + " requires " + q.requires(pName));
            System.out.println(String.valueOf(pName) + " is " + (q.readonly(pName) ? "" : "not ") + "readonly.");
            System.out.println("parameter " + pName + " is " + (q.isSet(pName) ? "" : "not ") + "set");
        }
        Collection allCatNames = q.catalogues();
        it = allCatNames.iterator();
        while (it.hasNext()) {
            String cName = (String)it.next();
            System.out.println("catalogue " + cName + " contains parameters " + q.findByCatalogue(cName));
        }
        q.setValue("date", (Object)new String[]{"2003-06-13 11:00:00", "2003-06-17 11:00:00"});
        Data date = q.get("date");
        date.setValue((Object)new String[]{"2003-06-13 11:00:00", "2003-06-17 11:00:00"});
        q.set("date", date);
        Data flares = q.getResult("goes_xray_flare");
        EGSOContext ctx = q.getContext(null);
        System.out.println("context was:\n" + ctx + "\n");
        String src = q.getQuerySource(null);
        System.out.println("query source code was:\n" + src + "\n");
        System.out.println("number of events = " + flares.size());
        System.out.println("flare result list is " + (flares.readonly() ? "" : "not ") + "readonly.");
        System.out.println("there is " + (flares.contains((Object)"3") ? "a" : "no") + " third event.");
        System.out.print("make a copy of the list... ");
        flares.clone();
        System.out.println("done.");
        System.out.println("the contents of the list prettyprinted:\n");
        flares.prettyPrint(System.out);
        Data flareselect = q.get("goes_xray_flare");
        flareselect.add((Object)flares.get("2"));
        flareselect.add((Object)flares.get(1));
        flareselect.remove((Object)flareselect.get(0));
        q.set("goes_xray_flare", flareselect);
        System.out.println("assert " + flareselect.get(0).id() + " = 1");
        ((WSQuery)q).dispose();
    }
}

